/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.jcl;

import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import org.apache.commons.logging.Log;

class ChronicleLogger
implements Log {
    private final String name;
    private final ChronicleLogWriter appender;
    private final ChronicleLogLevel level;

    ChronicleLogger(ChronicleLogWriter writer, String name, ChronicleLogLevel level) {
        this.appender = writer;
        this.name = name;
        this.level = level;
    }

    String name() {
        return this.name;
    }

    ChronicleLogWriter writer() {
        return this.appender;
    }

    ChronicleLogLevel level() {
        return this.level;
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.DEBUG);
    }

    public void debug(Object o) {
        this.append(ChronicleLogLevel.DEBUG, String.valueOf(o));
    }

    public void debug(Object o, Throwable throwable) {
        this.append(ChronicleLogLevel.DEBUG, String.valueOf(o), throwable);
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.TRACE);
    }

    public void trace(Object o) {
        this.append(ChronicleLogLevel.TRACE, String.valueOf(o));
    }

    public void trace(Object o, Throwable throwable) {
        this.append(ChronicleLogLevel.TRACE, String.valueOf(o), throwable);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.INFO);
    }

    public void info(Object o) {
        this.append(ChronicleLogLevel.INFO, String.valueOf(o));
    }

    public void info(Object o, Throwable throwable) {
        this.append(ChronicleLogLevel.INFO, String.valueOf(o), throwable);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.WARN);
    }

    public void warn(Object o) {
        this.append(ChronicleLogLevel.WARN, String.valueOf(o));
    }

    public void warn(Object o, Throwable throwable) {
        this.append(ChronicleLogLevel.WARN, String.valueOf(o), throwable);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.ERROR);
    }

    public void error(Object o) {
        this.append(ChronicleLogLevel.ERROR, String.valueOf(o));
    }

    public void error(Object o, Throwable throwable) {
        this.append(ChronicleLogLevel.ERROR, String.valueOf(o), throwable);
    }

    public boolean isFatalEnabled() {
        return this.isLevelEnabled(ChronicleLogLevel.ERROR);
    }

    public void fatal(Object o) {
        this.append(ChronicleLogLevel.ERROR, String.valueOf(o));
    }

    public void fatal(Object o, Throwable throwable) {
        this.append(ChronicleLogLevel.ERROR, String.valueOf(o), throwable);
    }

    private boolean isLevelEnabled(ChronicleLogLevel level) {
        return level.isHigherOrEqualTo(this.level);
    }

    private void append(ChronicleLogLevel level, String message) {
        if (level.isHigherOrEqualTo(this.level)) {
            this.appender.write(level, System.currentTimeMillis(), Thread.currentThread().getName(), this.name, message, null, new Object[0]);
        }
    }

    private void append(ChronicleLogLevel level, String message, Throwable throwable) {
        if (level.isHigherOrEqualTo(this.level)) {
            this.appender.write(level, System.currentTimeMillis(), Thread.currentThread().getName(), this.name, message, throwable, new Object[0]);
        }
    }
}

