/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.jcl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogManager;
import net.openhft.chronicle.logger.jcl.ChronicleLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.NoOpLog;

public class ChronicleLoggerFactory
extends LogFactory {
    private static final Log NOP_LOGGER = new NoOpLog();
    private final Map<String, ChronicleLogger> loggers;
    private final ChronicleLogManager manager;

    public ChronicleLoggerFactory() {
        ChronicleLoggerFactory.logRawDiagnostic((String)"[CHRONICLE] Initialize ChronicleLoggerFactory");
        this.loggers = new ConcurrentHashMap<String, ChronicleLogger>();
        this.manager = ChronicleLogManager.getInstance();
        ChronicleLoggerFactory.logRawDiagnostic((String)"[CHRONICLE] ChronicleLoggerFactory initialized");
    }

    public void release() {
        this.loggers.clear();
        this.manager.clear();
    }

    public Object getAttribute(String s) {
        return null;
    }

    public void setAttribute(String s, Object o) {
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public void removeAttribute(String s) {
    }

    public Log getInstance(Class type) throws LogConfigurationException {
        return this.getInstance(type.getName());
    }

    public Log getInstance(String name) throws LogConfigurationException {
        try {
            return this.getLogger(name);
        }
        catch (Exception e) {
            System.err.println("Unable to inzialize chronicle-jcl " + "(" + name + ")" + "\n  " + e.getMessage());
            return NOP_LOGGER;
        }
    }

    private synchronized Log getLogger(String name) throws Exception {
        ChronicleLogger logger = this.loggers.get(name);
        if (logger == null) {
            logger = new ChronicleLogger(this.manager.createWriter(name), name, ChronicleLogLevel.fromStringLevel((CharSequence)this.manager.cfg().getString(name, "level")));
            this.loggers.put(name, logger);
        }
        return logger;
    }
}

