/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class DefaultChronicleLogWriter
implements ChronicleLogWriter {
    private static final ThreadLocal<Boolean> REENTRANCY_FLAG = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<SimpleDateFormat> tsFormatter = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    private final ChronicleQueue cq;

    public DefaultChronicleLogWriter(@NotNull ChronicleQueue cq) {
        this.cq = cq;
    }

    @Override
    public void close() {
        this.cq.close();
    }

    @Override
    public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message) {
        this.write(level, timestamp, threadName, loggerName, message, null, new Object[0]);
    }

    @Override
    public void write(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object ... args) {
        if (REENTRANCY_FLAG.get().booleanValue() || this.cq.isClosed()) {
            DefaultChronicleLogWriter.printLogMessage(level, timestamp, threadName, loggerName, message, throwable, args);
            return;
        }
        REENTRANCY_FLAG.set(true);
        try {
            this.writeToQueue(level, timestamp, threadName, loggerName, message, throwable, args);
        }
        catch (ClosedIllegalStateException t) {
            DefaultChronicleLogWriter.printLogMessage(level, timestamp, threadName, loggerName, message, throwable, args);
        }
    }

    private static void printLogMessage(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object[] args) {
        if (throwable == null) {
            System.err.printf("%s [%s] %s %s - %s%s%n", tsFormatter.get().format(timestamp), threadName, level.toString(), loggerName, message, Arrays.toString(args));
        } else {
            System.err.printf("%s [%s] %s %s - %s%s - %s%n", tsFormatter.get().format(timestamp), threadName, level.toString(), loggerName, message, Arrays.toString(args), throwable);
            throwable.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToQueue(ChronicleLogLevel level, long timestamp, String threadName, String loggerName, String message, Throwable throwable, Object[] args) {
        try (ExcerptAppender appender = this.cq.createAppender();
             DocumentContext dc = appender.writingDocument();){
            Wire wire = dc.wire();
            assert (wire != null);
            wire.write((CharSequence)"ts").int64(timestamp).write((CharSequence)"level").asEnum((Enum)level).write((CharSequence)"threadName").text(threadName).write((CharSequence)"loggerName").text(loggerName).write((CharSequence)"message").text(message);
            if (throwable != null) {
                wire.write((CharSequence)"throwable").throwable(throwable);
            }
            if (args != null && args.length > 0) {
                wire.write((CharSequence)"args").sequence(vo -> {
                    for (Object o : args) {
                        try {
                            vo.object(o);
                        }
                        catch (IllegalArgumentException unsupported) {
                            vo.text(o.toString());
                        }
                    }
                });
            }
        }
        finally {
            REENTRANCY_FLAG.set(false);
        }
    }

    public WireType getWireType() {
        return this.cq.wireType();
    }
}

