/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogAppenderConfig {
    private static final String[] KEYS = new String[]{"blockSize", "bufferCapacity", "rollCycle"};
    private int blockSize;
    private long bufferCapacity;
    private String rollCycle;

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public long getBufferCapacity() {
        return this.bufferCapacity;
    }

    public void setBufferCapacity(long bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    public String getRollCycle() {
        return this.rollCycle;
    }

    public void setRollCycle(String rollCycle) {
        this.rollCycle = rollCycle;
    }

    public String[] keys() {
        return KEYS;
    }

    public ChronicleQueue build(String path, String wireType) {
        WireType wireTypeEnum = wireType != null ? WireType.valueOf((String)wireType.toUpperCase()) : WireType.BINARY_LIGHT;
        SingleChronicleQueueBuilder builder = ChronicleQueue.singleBuilder((String)path).wireType(wireTypeEnum).blockSize(this.blockSize).bufferCapacity(this.bufferCapacity);
        if (this.rollCycle != null) {
            builder.rollCycle((RollCycle)RollCycles.valueOf((String)this.rollCycle));
        }
        return builder.build();
    }

    public void setProperties(@NotNull Properties properties, @Nullable String prefix) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (prefix != null && !prefix.isEmpty()) {
                if (!name.startsWith(prefix)) continue;
                this.setProperty(name.substring(prefix.length()), value);
                continue;
            }
            this.setProperty(name, value);
        }
    }

    public void setProperty(@NotNull String propName, @NotNull String propValue) {
        try {
            PropertyDescriptor property = new PropertyDescriptor(propName, this.getClass());
            Method method = property.getWriteMethod();
            Class<?> type = method.getParameterTypes()[0];
            if (type != null && propValue != null && !propValue.isEmpty()) {
                if (type == Integer.TYPE) {
                    method.invoke((Object)this, Integer.parseInt(propValue));
                } else if (type == Long.TYPE) {
                    method.invoke((Object)this, Long.parseLong(propValue));
                } else if (type == Boolean.TYPE) {
                    method.invoke((Object)this, Boolean.parseBoolean(propValue));
                } else if (type == String.class) {
                    method.invoke((Object)this, propValue);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

