/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.logger.ChronicleLogConfig;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.DefaultChronicleLogWriter;
import net.openhft.chronicle.queue.ChronicleQueue;

public class ChronicleLogManager {
    private ChronicleLogConfig cfg = ChronicleLogConfig.load();
    private Map<String, ChronicleLogWriter> writers = new ConcurrentHashMap<String, ChronicleLogWriter>();

    private ChronicleLogManager() {
    }

    public static ChronicleLogManager getInstance() {
        return Holder.INSTANCE;
    }

    public ChronicleLogConfig cfg() {
        return this.cfg;
    }

    public void clear() {
        for (ChronicleLogWriter writer : this.writers.values()) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        this.writers.clear();
    }

    public void reload() {
        this.clear();
        this.cfg = ChronicleLogConfig.load();
        this.writers = new ConcurrentHashMap<String, ChronicleLogWriter>();
    }

    public ChronicleLogWriter getWriter(String name) throws IOException {
        if (this.cfg == null) {
            throw new IllegalArgumentException("ChronicleLogManager is not configured");
        }
        String path = this.cfg.getString(name, "path");
        if (path != null) {
            ChronicleLogWriter logWriter = this.writers.get(path);
            if (logWriter == null) {
                logWriter = new DefaultChronicleLogWriter(this.newChronicle(path, name));
                this.writers.put(path, logWriter);
            }
            return logWriter;
        }
        throw new IllegalArgumentException("chronicle.logger.root.path is not defined, chronicle.logger." + name + ".path is not defined");
    }

    private ChronicleQueue newChronicle(String path, String name) throws IOException {
        String wireType = this.cfg.getString(name, "wireType");
        ChronicleQueue cq = this.cfg.getAppenderConfig().build(path, wireType);
        if (!this.cfg.getBoolean(name, "append", true).booleanValue()) {
            // empty if block
        }
        return cq;
    }

    private static class Holder {
        private static final ChronicleLogManager INSTANCE = new ChronicleLogManager();

        private Holder() {
        }
    }
}

