/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.LongArrays;
import com.koloboke.collect.impl.Maths;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.LHashCapacities;
import com.koloboke.function.LongObjConsumer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.LongFunction;
import net.openhft.chronicle.decentred.util.LongObjMap;

@SuppressFBWarnings(value={"IA_AMBIGUOUS_INVOCATION_OF_INHERITED_OR_OUTER_METHOD"})
final class KolobokeLongObjMap<V>
extends LongObjMap<V> {
    long freeValue;
    V[] values;
    long[] set;
    private HashConfigWrapper configWrapper;
    int size;
    private int maxSize;
    private int modCount = 0;
    static final HashConfigWrapper DEFAULT_CONFIG_WRAPPER = new HashConfigWrapper(HashConfig.getDefault());

    KolobokeLongObjMap(int expectedSize) {
        this.init(DEFAULT_CONFIG_WRAPPER, expectedSize);
    }

    static void verifyConfig(HashConfig config) {
        if (config.getGrowthFactor() != 2.0) {
            throw new IllegalArgumentException(config + " passed, HashConfig for a hashtable\n" + "implementation with linear probing must have growthFactor of 2.0.\n" + "A Koloboke Compile-generated hashtable implementation could have\n" + "a different growth factor, if the implemented type is annotated with\n" + "@com.koloboke.compile.hash.algo.openaddressing.QuadraticProbing or\n" + "@com.koloboke.compile.hash.algo.openaddressing.DoubleHashing");
        }
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(long key) {
        return this.contains(key);
    }

    public int capacity() {
        return this.set.length;
    }

    final void init(HashConfigWrapper configWrapper, int size, long freeValue) {
        this.freeValue = freeValue;
        this.init(configWrapper, size);
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final int modCount() {
        return this.modCount;
    }

    final void incrementModCount() {
        ++this.modCount;
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long free = this.freeValue;
        if (key != free) {
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
            long cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }

    final void init(HashConfigWrapper configWrapper, int size) {
        KolobokeLongObjMap.verifyConfig(configWrapper.config());
        this.configWrapper = configWrapper;
        this.size = 0;
        this.internalInit(this.targetCapacity(size));
    }

    private void internalInit(int capacity) {
        assert (Maths.isPowerOf2((int)capacity));
        this.maxSize = this.maxSize(capacity);
        this.allocateArrays(capacity);
    }

    private int maxSize(int capacity) {
        return !this.isMaxCapacity(capacity) ? this.configWrapper.maxSize(capacity) : capacity - 1;
    }

    @Override
    public V get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    private long findNewFreeOrRemoved() {
        long newFree;
        long free = this.freeValue;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((newFree = ((Random)random).nextLong()) == free || this.index(newFree) >= 0) {
        }
        return newFree;
    }

    long changeFree() {
        int mc = this.modCount();
        long newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        LongArrays.replaceAll((long[])this.set, (long)this.freeValue, (long)newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    int insert(long key, V value) {
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
        long cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return index;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return index;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    final void initForRehash(int newCapacity) {
        ++this.modCount;
        this.internalInit(newCapacity);
    }

    private void _MutableSeparateKVLongLHashSO_allocateArrays(int capacity) {
        this.set = new long[capacity];
        if (this.freeValue != 0L) {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    private void _MutableLHash_clear() {
        ++this.modCount;
        this.size = 0;
    }

    private void _MutableSeparateKVLongLHashSO_clear() {
        this._MutableLHash_clear();
        Arrays.fill(this.set, this.freeValue);
    }

    @Override
    public void forEach(LongObjConsumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    void allocateArrays(int capacity) {
        this._MutableSeparateKVLongLHashSO_allocateArrays(capacity);
        this.values = new Object[capacity];
    }

    private void _MutableLHashSeparateKVLongObjMapSO_clear() {
        this._MutableSeparateKVLongLHashSO_clear();
        Arrays.fill(this.values, null);
    }

    final void postRemoveHook() {
        --this.size;
    }

    final void postInsertHook() {
        int capacity;
        if (++this.size > this.maxSize && !this.isMaxCapacity(capacity = this.capacity())) {
            this.rehash(capacity << 1);
        }
    }

    boolean doubleSizedArrays() {
        return false;
    }

    private int targetCapacity(int size) {
        return LHashCapacities.capacity((HashConfigWrapper)this.configWrapper, (int)size, (boolean)this.doubleSizedArrays());
    }

    private boolean isMaxCapacity(int capacity) {
        return LHashCapacities.isMaxCapacity((int)capacity, (boolean)this.doubleSizedArrays());
    }

    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        V[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        V[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            int index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
            if (newKeys[index] != free) {
                while (newKeys[index = index - 1 & capacityMask] != free) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void justPut(long key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public V computeIfAbsent(long key, LongFunction<? extends V> mappingFunction) {
        block6: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block6;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                if ((value = mappingFunction.apply(key)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value;
                    this.postInsertHook();
                    return value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return val;
        }
        value = mappingFunction.apply(key);
        if (value != null) {
            vals[index] = value;
            return value;
        }
        return null;
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        this._MutableLHashSeparateKVLongObjMapSO_clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean justRemove(long key) {
        long free = this.freeValue;
        if (key != free) {
            long keyToShift;
            int indexToRemove;
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            V[] vals = this.values;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVLongKeyMixing.mix((long)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            vals[indexToRemove] = null;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    KolobokeLongObjMap(HashConfig hashConfig, int expectedSize) {
        this.init(new HashConfigWrapper(hashConfig), expectedSize);
    }

    static class Support {
        Support() {
        }
    }
}

