/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.server;

import net.openhft.chronicle.decentred.api.MessageToListener;
import net.openhft.chronicle.decentred.dto.TransactionBlockGossipEvent;
import net.openhft.chronicle.decentred.dto.TransactionBlockVoteEvent;
import net.openhft.chronicle.decentred.server.VanillaVoteTaker;
import net.openhft.chronicle.decentred.server.Voter;
import net.openhft.chronicle.wire.Marshallable;

public class VanillaVoter
implements Voter {
    private final long address;
    private final long[] clusterAddresses;
    private final VanillaVoteTaker voteTaker;
    private MessageToListener tcpMessageListener;
    private TransactionBlockGossipEvent gossip = new TransactionBlockGossipEvent();
    private TransactionBlockVoteEvent vote = new TransactionBlockVoteEvent();

    public VanillaVoter(long address, long[] clusterAddresses, VanillaVoteTaker voteTaker) {
        this.address = address;
        this.clusterAddresses = clusterAddresses;
        this.voteTaker = voteTaker;
    }

    @Override
    public synchronized void transactionBlockGossipEvent(TransactionBlockGossipEvent transactionBlockGossipEvent) {
        System.out.println("Received " + transactionBlockGossipEvent);
        transactionBlockGossipEvent.copyTo((Marshallable)this.gossip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendVote(long blockNumber) {
        if (this.gossip.addressToBlockNumberMap().size() == 0) {
            return;
        }
        this.vote.reset();
        VanillaVoter vanillaVoter = this;
        synchronized (vanillaVoter) {
            this.gossip.copyTo((Marshallable)this.vote.gossipEvent());
        }
        for (Object clusterAddress : (VanillaVoter)this.clusterAddresses) {
            if (this.address == clusterAddress) {
                this.voteTaker.transactionBlockVoteEvent(this.vote);
                continue;
            }
            this.tcpMessageListener.onMessageTo((long)clusterAddress, this.vote);
        }
    }

    public VanillaVoter tcpMessageListener(MessageToListener tcpMessageListener) {
        this.tcpMessageListener = tcpMessageListener;
        return this;
    }
}

