/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.decentred.api.ConnectionStatusListener;
import net.openhft.chronicle.decentred.api.MessageRouter;
import net.openhft.chronicle.decentred.api.Verifier;
import net.openhft.chronicle.decentred.dto.InvalidationEvent;
import net.openhft.chronicle.decentred.dto.VerificationEvent;
import net.openhft.chronicle.decentred.remote.net.TCPConnection;

public class VanillaVerifyIP
implements Verifier,
ConnectionStatusListener {
    private final MessageRouter<Verifier> client;
    private final Map<BytesStore, List<VerificationEvent>> verifyMap = new HashMap<BytesStore, List<VerificationEvent>>();

    public VanillaVerifyIP(MessageRouter<Verifier> client) {
        this.client = client;
    }

    @Override
    public void onConnection(TCPConnection connection) {
        Verifier to = this.client.to(0L);
        for (List<VerificationEvent> verificationEventList : this.verifyMap.values()) {
            for (VerificationEvent verificationEvent : verificationEventList) {
                to.verificationEvent(verificationEvent);
            }
        }
    }

    @Override
    public void verificationEvent(VerificationEvent verificationEvent) {
        List verificationEventList = this.verifyMap.computeIfAbsent(verificationEvent.keyVerified(), k -> new ArrayList());
        VerificationEvent v2 = (VerificationEvent)verificationEvent.deepCopy();
        verificationEventList.add(v2);
        this.client.to(0L).verificationEvent(verificationEvent);
    }

    @Override
    public void invalidationEvent(InvalidationEvent invalidationEvent) {
        this.verifyMap.remove(invalidationEvent.publicKey());
        this.client.to(0L).invalidationEvent(invalidationEvent);
    }
}

