/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.server;

import java.util.stream.LongStream;
import net.openhft.chronicle.decentred.api.MessageToListener;
import net.openhft.chronicle.decentred.dto.TransactionBlockEvent;
import net.openhft.chronicle.decentred.dto.TransactionBlockGossipEvent;
import net.openhft.chronicle.decentred.server.Gossiper;
import net.openhft.chronicle.decentred.server.Voter;
import net.openhft.chronicle.decentred.util.LongLongMap;

public class VanillaGossiper
implements Gossiper {
    private static final Long NO_BLOCK = -1L;
    private final long address;
    private final LongLongMap lastBlockMap = LongLongMap.withExpectedSize(16);
    private final long[] clusterAddresses;
    private final Voter voter;
    private final TransactionBlockGossipEvent gossip;
    private MessageToListener tcpMessageToListener;

    public VanillaGossiper(long address, long chainAddress, long[] clusterAddresses, Voter voter) {
        this.address = address;
        this.clusterAddresses = clusterAddresses;
        this.voter = voter;
        assert (LongStream.of(clusterAddresses).anyMatch(a -> a == address));
        this.gossip = new TransactionBlockGossipEvent().chainAddress(chainAddress);
    }

    @Override
    public synchronized void transactionBlockEvent(TransactionBlockEvent transactionBlockEvent) {
        long blockNumber;
        long sourceAddress = transactionBlockEvent.address();
        if (sourceAddress == 0L) {
            System.err.println("Missing sourceAddress " + transactionBlockEvent);
            return;
        }
        long lastBlockNumber = this.lastBlockMap.getOrDefault(sourceAddress, NO_BLOCK);
        if (lastBlockNumber < (blockNumber = transactionBlockEvent.blockNumber())) {
            this.lastBlockMap.justPut(sourceAddress, blockNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendGossip(long blockNumber) {
        if (this.lastBlockMap.size() == 0) {
            return;
        }
        this.gossip.reset();
        this.gossip.address(this.address);
        this.gossip.blockNumber(blockNumber);
        VanillaGossiper vanillaGossiper = this;
        synchronized (vanillaGossiper) {
            this.gossip.addressToBlockNumberMap().putAll(this.lastBlockMap);
        }
        for (Object clusterAddress : (VanillaGossiper)this.clusterAddresses) {
            if (clusterAddress == this.address) {
                this.voter.transactionBlockGossipEvent(this.gossip);
                continue;
            }
            this.tcpMessageToListener.onMessageTo((long)clusterAddress, this.gossip);
        }
    }

    public VanillaGossiper tcpMessageToListener(MessageToListener tcpMessageToListener) {
        this.tcpMessageToListener = tcpMessageToListener;
        return this;
    }
}

