/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.server;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.decentred.api.MessageToListener;
import net.openhft.chronicle.decentred.dto.SignedMessage;
import net.openhft.chronicle.decentred.server.RunningMessageToListener;
import net.openhft.chronicle.decentred.server.SingleMessageToListener;

public class MultiMessageToListener
implements RunningMessageToListener {
    final SingleMessageToListener[] messageWriters;
    private final int mask;

    public MultiMessageToListener(int count, MessageToListener xclServer) {
        count = Maths.nextPower2((int)count, (int)2);
        this.mask = count - 1;
        this.messageWriters = new SingleMessageToListener[count];
        for (int i = 0; i < count; ++i) {
            this.messageWriters[i] = new SingleMessageToListener(xclServer);
        }
    }

    @Override
    public void onMessageTo(long address, SignedMessage message) {
        this.messageWriters[(int)(Maths.agitate((long)address) & (long)this.mask)].onMessageTo(address, message);
    }

    @Override
    public Runnable[] runnables() {
        return this.messageWriters;
    }
}

