/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.remote.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.decentred.remote.net.TCPConnection;
import net.openhft.chronicle.decentred.remote.net.TCPServer;
import net.openhft.chronicle.decentred.remote.net.TCPServerConnectionListener;
import net.openhft.chronicle.threads.NamedThreadFactory;

public class VanillaTCPServer
implements TCPServer {
    private final ServerSocketChannel serverChannel;
    private final ExecutorService pool;
    private final List<TCPConnection> connections = Collections.synchronizedList(new ArrayList());
    private final TCPServerConnectionListener connectionListener;
    private volatile boolean running = true;

    public VanillaTCPServer(String name, int port, TCPServerConnectionListener connectionListener) throws IOException {
        this.connectionListener = connectionListener;
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.bind(new InetSocketAddress(port));
        this.pool = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(name, Boolean.valueOf(false), Integer.valueOf(1)));
        this.pool.submit(this::run);
    }

    private void run() {
        try {
            while (this.running) {
                SocketChannel accept = this.serverChannel.accept();
                Object connection = this.connectionListener.createConnection(this, accept);
                this.connections.add((TCPConnection)connection);
                this.pool.submit((Runnable)connection);
            }
        }
        catch (Throwable t) {
            if (this.running) {
                t.printStackTrace();
            }
            this.close();
        }
    }

    public void close() {
        this.running = false;
        this.pool.shutdown();
        Closeable.closeQuietly(this.connections);
        Closeable.closeQuietly((Object)this.serverChannel);
    }

    @Override
    public TCPServerConnectionListener connectionListener() {
        return this.connectionListener;
    }
}

