/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.dto;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.time.UniqueMicroTimeProvider;
import net.openhft.chronicle.decentred.dto.SignedMessage;
import net.openhft.chronicle.decentred.util.AddressLongConverter;
import net.openhft.chronicle.salt.Ed25519;
import net.openhft.chronicle.wire.AbstractBytesMarshallable;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.MicroTimestampLongConverter;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;

public class VanillaSignedMessage<T extends VanillaSignedMessage<T>>
extends AbstractBytesMarshallable
implements SignedMessage {
    private static final int LENGTH = 0;
    private static final int LENGTH_END = 4;
    private static final int SIGNATURE = 4;
    private static final int SIGNATURE_END = 68;
    public static final int MESSAGE_TYPE = 68;
    private static final int MESSAGE_TYPE_END = 70;
    private static final int PROTOCOL = 70;
    private static final int PROTOCOL_END = 72;
    private static final int MESSAGE_START = 72;
    private static final Field BB_ADDRESS = Jvm.getField(ByteBuffer.allocateDirect(0).getClass(), (String)"address");
    private static final Field BB_CAPACITY = Jvm.getField(ByteBuffer.allocateDirect(0).getClass(), (String)"capacity");
    private transient Bytes tempBytes = Bytes.allocateElasticDirect((long)4096L);
    private transient PointerBytesStore readPointer = BytesStore.nativePointer();
    protected transient Bytes<Void> bytes = this.readPointer.bytesForRead();
    private transient boolean signed = false;
    private transient ByteBuffer byteBuffer;
    private transient int messageType;
    private transient int protocol;
    @LongConversion(value=MicroTimestampLongConverter.class)
    private long timestampUS;
    @LongConversion(value=AddressLongConverter.class)
    private long address;

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        this.signed = false;
        super.readMarshallable(wire);
    }

    public void readMarshallable(BytesIn bytes) throws IORuntimeException {
        long capacity = bytes.readRemaining();
        this.readPointer.set(bytes.addressForRead(bytes.readPosition()), capacity);
        this.messageType = this.readPointer.readShort(68L);
        this.protocol = this.readPointer.readShort(70L);
        this.bytes.clear();
        this.bytes.readPositionRemaining(72L, capacity - 72L);
        super.readMarshallable(this.bytes);
        this.signed = true;
    }

    public void reset() {
        this.signed = false;
        super.reset();
    }

    @Override
    public boolean signed() {
        return this.signed;
    }

    public void writeMarshallable(BytesOut bytes) {
        assert (this.signed());
        bytes.write(this.bytes, 0L, this.bytes.readLimit());
    }

    protected void writeMarshallable0(BytesOut bytes) {
        super.writeMarshallable(bytes);
    }

    @Override
    public long address() {
        return this.address;
    }

    public T address(long address) {
        assert (!this.signed());
        this.address = address;
        return (T)this;
    }

    @Override
    public long timestampUS() {
        return this.timestampUS;
    }

    public T timestampUS(long timestampUS) {
        assert (!this.signed());
        this.timestampUS = timestampUS;
        return (T)this;
    }

    @Override
    public BytesStore publicKey() {
        return NoBytesStore.noBytesStore();
    }

    public boolean hasPublicKey() {
        return false;
    }

    public T publicKey(BytesStore key) {
        assert (false);
        return (T)this;
    }

    public T sign(BytesStore secretKey) {
        UniqueMicroTimeProvider timeProvider = UniqueMicroTimeProvider.INSTANCE;
        return this.sign(secretKey, (TimeProvider)timeProvider);
    }

    public T sign(BytesStore secretKey, TimeProvider timeProvider) {
        assert (!this.signed()) : "Already signed";
        assert (this.protocol != 0) : "protocol must be set";
        assert (this.messageType != 0) : "messageType must be set";
        if (this.hasPublicKey()) {
            this.publicKey(secretKey);
        }
        this.address = secretKey.readLong(secretKey.readRemaining() - 8L);
        this.timestampUS = timeProvider.currentTimeMicros();
        this.tempBytes.clear();
        this.tempBytes.writeInt(0);
        long signatureStart = this.tempBytes.writePosition();
        this.tempBytes.writeSkip(64L);
        this.tempBytes.writeUnsignedShort(this.messageType);
        this.tempBytes.writeUnsignedShort(this.protocol);
        this.writeMarshallable0((BytesOut)this.tempBytes);
        long length = this.tempBytes.readRemaining();
        this.tempBytes.writeUnsignedInt(0L, length);
        this.tempBytes.readPosition(signatureStart);
        Ed25519.sign((BytesStore)this.tempBytes, (BytesStore)secretKey);
        this.signed = true;
        this.readPointer.set(this.tempBytes.addressForRead(0L), length);
        ((Bytes)this.bytes.writeLimit(length)).readPositionRemaining(0L, length);
        return (T)this;
    }

    public String toHexString() {
        HexDumpBytes dump = new HexDumpBytes().offsetFormat((o, b) -> b.appendBase16(o, 4));
        dump.comment((CharSequence)"length").writeUnsignedInt(this.bytes.readUnsignedInt(0L));
        dump.comment((CharSequence)"signature start").write(this.bytes, 4L, 64L);
        dump.comment((CharSequence)"signature end");
        dump.comment((CharSequence)"messageType").writeUnsignedShort(this.messageType);
        dump.comment((CharSequence)"protocol").writeUnsignedShort(this.protocol);
        this.writeMarshallable0((BytesOut)dump);
        String text = dump.toHexString();
        dump.release();
        return text;
    }

    public boolean verify(LongFunction<BytesStore> addressToPublickKey) {
        BytesStore publicKey;
        BytesStore bytesStore = publicKey = this.hasPublicKey() ? this.publicKey() : addressToPublickKey.apply(this.address());
        if (publicKey == null || publicKey.readRemaining() != 32L) {
            return false;
        }
        this.bytes.readPosition(4L);
        this.bytes.readLimit(this.readPointer.readLimit());
        return Ed25519.verify(this.bytes, (BytesStore)publicKey);
    }

    @Override
    public int protocol() {
        return this.protocol;
    }

    public T protocol(int protocol) {
        this.protocol = protocol;
        return (T)this;
    }

    public String protocolString() {
        return this.getClass().getPackage().getName();
    }

    @Override
    public int messageType() {
        return this.messageType;
    }

    public T messageType(int messageType) {
        this.messageType = messageType;
        return (T)this;
    }

    public String messageTypeString() {
        return this.getClass().getSimpleName();
    }

    public BytesStore bytes() {
        return this.readPointer;
    }

    public ByteBuffer byteBuffer() {
        if (this.byteBuffer == null) {
            this.byteBuffer = ByteBuffer.allocateDirect(0);
        }
        try {
            BB_ADDRESS.setLong(this.byteBuffer, this.readPointer.addressForRead(0L));
            BB_CAPACITY.setInt(this.byteBuffer, Math.toIntExact(this.readPointer.readRemaining()));
            this.byteBuffer.clear();
            return this.byteBuffer;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

