/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.scoped.ScopedResourcePool;
import net.openhft.chronicle.core.scoped.ScopedThreadLocal;

public final class StringBuilderPool {
    private static final int DEFAULT_STRING_BUILDER_POOL_SIZE_PER_THREAD = Jvm.getInteger("chronicle.stringBuilderPool.instancesPerThread", 4);
    private final ThreadLocal<StringBuilder> sbtl = ThreadLocal.withInitial(() -> new StringBuilder(128));

    public static ScopedResourcePool<StringBuilder> createThreadLocal() {
        return StringBuilderPool.createThreadLocal(DEFAULT_STRING_BUILDER_POOL_SIZE_PER_THREAD);
    }

    public static ScopedResourcePool<StringBuilder> createThreadLocal(int instancesPerThread) {
        return new ScopedThreadLocal<StringBuilder>(() -> new StringBuilder(128), sb -> sb.setLength(0), instancesPerThread);
    }
}

