/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.cleaner;

import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.TargetMajorVersion;
import net.openhft.chronicle.core.cleaner.spi.ByteBufferCleanerService;
import net.openhft.chronicle.core.internal.cleaner.ReflectionBasedByteBufferCleanerService;

public final class CleanerServiceLocator {
    private static boolean initialised = false;
    private static ByteBufferCleanerService instance;

    private CleanerServiceLocator() {
    }

    public static synchronized ByteBufferCleanerService cleanerService() {
        if (!initialised) {
            ServiceLoader<ByteBufferCleanerService> available = ServiceLoader.load(ByteBufferCleanerService.class, Thread.currentThread().getContextClassLoader());
            ByteBufferCleanerService cleanerService = null;
            try {
                for (ByteBufferCleanerService next : available) {
                    if (!CleanerServiceLocator.isAllowedInThisMajorVersion(next) || cleanerService != null && next.impact().compareTo(cleanerService.impact()) >= 0) continue;
                    cleanerService = next;
                }
            }
            catch (ServiceConfigurationError e) {
                Jvm.error().on(CleanerServiceLocator.class, "Error while trying to load service providers", (Throwable)e);
            }
            if (cleanerService == null) {
                cleanerService = new ReflectionBasedByteBufferCleanerService();
                Jvm.warn().on(CleanerServiceLocator.class, "Unable to find suitable cleaner service, falling back to using reflection");
            }
            instance = cleanerService;
            initialised = true;
        }
        return instance;
    }

    private static boolean isAllowedInThisMajorVersion(ByteBufferCleanerService svc) {
        TargetMajorVersion version = svc.getClass().getDeclaredAnnotation(TargetMajorVersion.class);
        return version == null || version.majorVersion() == 0 || version.majorVersion() == Jvm.majorVersion() || version.includeNewer() && Jvm.majorVersion() > version.majorVersion() || version.includeOlder() && Jvm.majorVersion() < version.majorVersion();
    }
}

