/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.internal.CloseableUtils;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;

public abstract class AbstractCloseableReferenceCounted
extends AbstractReferenceCounted
implements ManagedCloseable {
    private volatile transient boolean closing;
    private volatile transient boolean closed;
    private volatile transient StackTrace closedHere;
    private boolean initReleased;

    protected AbstractCloseableReferenceCounted() {
        CloseableUtils.add(this);
    }

    @Override
    public void reserve(ReferenceOwner id) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.throwExceptionIfClosed();
        super.reserve(id);
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.throwExceptionIfClosed();
        super.reserveTransfer(from, to);
        if (from == INIT) {
            this.initReleased = true;
        }
        if (to == INIT) {
            this.initReleased = false;
        }
    }

    @Override
    public void release(ReferenceOwner id) throws ClosedIllegalStateException {
        super.release(id);
        if (id == INIT) {
            this.initReleased = true;
        }
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws ClosedIllegalStateException {
        super.releaseLast(id);
        if (id == INIT) {
            this.initReleased = true;
        }
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws ClosedIllegalStateException, IllegalArgumentException {
        return !this.closed && super.tryReserve(id);
    }

    @Override
    public void close() {
        this.setClosing();
        if (!this.initReleased) {
            try {
                this.release(INIT);
            }
            catch (IllegalStateException e) {
                Jvm.warn().on(this.getClass(), "Failed to release LAST, closing anyway", (Throwable)e);
            }
        }
        this.setClosed();
    }

    @Override
    protected void backgroundPerformRelease() {
        this.setClosing();
        super.backgroundPerformRelease();
    }

    protected void setClosing() {
        this.closing = true;
        this.setClosedHere(" closing here");
    }

    private void setClosedHere(String s) {
        if (this.closedHere == null) {
            this.closedHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass().getName() + s) : null;
        }
    }

    protected void setClosed() {
        this.closed = true;
        this.closing = true;
        this.setClosedHere(" closed here");
    }

    @Override
    public void throwExceptionIfClosed() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.throwExceptionIfClosed0();
        this.throwExceptionIfReleased();
        assert (AbstractCloseable.DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
    }

    private void throwExceptionIfClosed0() throws ClosedIllegalStateException {
        if (this.closing) {
            this.throwClosing();
        }
    }

    private void throwClosing() throws ClosedIllegalStateException {
        throw new ClosedIllegalStateException(this.getClass().getName() + (this.closed ? " closed" : " closing"), this.closedHere);
    }

    protected void throwExceptionIfClosedInSetter() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.throwExceptionIfClosed0();
        this.throwExceptionIfReleased();
        assert (AbstractCloseable.DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(false));
    }

    @Override
    public boolean isClosed() {
        return this.refCount() <= 0 || this.closed;
    }
}

