/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntPredicate;
import net.openhft.chronicle.core.internal.invariant.ints.IntBiCondition;
import net.openhft.chronicle.core.internal.invariant.ints.IntCondition;
import net.openhft.chronicle.core.internal.invariant.ints.IntTriCondition;
import net.openhft.chronicle.core.util.IntBiPredicate;
import net.openhft.chronicle.core.util.IntTriPredicate;

public final class Ints {
    private Ints() {
    }

    public static int requireNonNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(Ints.failDescription(Ints.negative().negate(), value));
        }
        return value;
    }

    @Deprecated
    public static int require(IntPredicate requirement, int value) {
        return Ints.require(requirement, value, IllegalArgumentException::new);
    }

    @Deprecated
    public static <X extends RuntimeException> int require(IntPredicate requirement, int value, Function<String, X> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper);
        if (!requirement.test(value)) {
            throw (RuntimeException)exceptionMapper.apply(Ints.failDescription(requirement, value));
        }
        return value;
    }

    @Deprecated
    public static int require(IntBiPredicate requirement, int value, int otherValue) {
        if (!requirement.test(value, otherValue)) {
            throw new IllegalArgumentException(Ints.failDescription(requirement, value, otherValue));
        }
        return value;
    }

    @Deprecated
    public static <X extends RuntimeException> int require(IntBiPredicate requirement, int value, int otherValue, Function<String, X> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper);
        if (!requirement.test(value, otherValue)) {
            throw (RuntimeException)exceptionMapper.apply(Ints.failDescription(requirement, value, otherValue));
        }
        return value;
    }

    @Deprecated
    public static int require(IntTriPredicate requirement, int value, int otherFirstValue, int otherSecondValue) {
        return Ints.require(requirement, value, otherFirstValue, otherSecondValue, IllegalArgumentException::new);
    }

    @Deprecated
    public static <X extends RuntimeException> int require(IntTriPredicate requirement, int value, int otherFirstValue, int otherSecondValue, Function<String, X> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper);
        if (!requirement.test(value, otherFirstValue, otherSecondValue)) {
            throw (RuntimeException)exceptionMapper.apply(Ints.failDescription(requirement, value, otherFirstValue, otherSecondValue));
        }
        return value;
    }

    public static boolean assertIfEnabled(IntPredicate requirement, int value) {
        return true;
    }

    @Deprecated
    public static boolean assertIfEnabled(IntBiPredicate requirement, int value, int otherValue) {
        return true;
    }

    public static boolean assertIfEnabled(IntTriPredicate requirement, int value, int otherFirstValue, int otherSecondValue) {
        return true;
    }

    public static String failDescription(IntPredicate requirement, int value) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s", value, value, requirement);
    }

    public static String failDescription(IntBiPredicate requirement, int value, int otherValue) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s %d", value, value, requirement, otherValue);
    }

    public static String failDescription(IntTriPredicate requirement, int value, int otherFirstValue, int otherSecondValue) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s (%d, %d)", value, value, requirement, otherFirstValue, otherSecondValue);
    }

    @Deprecated
    public static IntPredicate positive() {
        return IntCondition.POSITIVE;
    }

    @Deprecated
    public static IntPredicate negative() {
        return IntCondition.NEGATIVE;
    }

    public static IntPredicate nonNegative() {
        return IntCondition.NON_NEGATIVE;
    }

    @Deprecated
    public static IntPredicate zero() {
        return IntCondition.ZERO;
    }

    @Deprecated
    public static IntPredicate byteConvertible() {
        return IntCondition.BYTE_CONVERTIBLE;
    }

    @Deprecated
    public static IntPredicate shortConvertible() {
        return IntCondition.SHORT_CONVERTIBLE;
    }

    @Deprecated
    public static IntPredicate evenPowerOfTwo() {
        return IntCondition.EVEN_POWER_OF_TWO;
    }

    @Deprecated
    public static IntPredicate shortAligned() {
        return IntCondition.SHORT_ALIGNED;
    }

    @Deprecated
    public static IntPredicate intAligned() {
        return IntCondition.INT_ALIGNED;
    }

    @Deprecated
    public static IntPredicate longAligned() {
        return IntCondition.LONG_ALIGNED;
    }

    @Deprecated
    public static IntBiPredicate equalTo() {
        return IntBiCondition.EQUAL_TO;
    }

    @Deprecated
    public static IntBiPredicate greaterThan() {
        return IntBiCondition.GREATER_THAN;
    }

    @Deprecated
    public static IntBiPredicate greaterOrEqual() {
        return IntBiCondition.GREATER_OR_EQUAL;
    }

    @Deprecated
    public static IntBiPredicate lessThan() {
        return IntBiCondition.LESS_THAN;
    }

    @Deprecated
    public static IntBiPredicate lessOrEqual() {
        return IntBiCondition.LESS_OR_EQUAL;
    }

    @Deprecated
    public static IntBiPredicate betweenZeroAnd() {
        return IntBiCondition.BETWEEN_ZERO_AND;
    }

    @Deprecated
    public static IntBiPredicate betweenZeroAndClosed() {
        return IntBiCondition.BETWEEN_ZERO_AND_CLOSED;
    }

    @Deprecated
    public static IntBiPredicate powerOfTwo() {
        return IntBiCondition.POWER_OF_TWO;
    }

    @Deprecated
    public static IntBiPredicate log2() {
        return IntBiCondition.LOG2;
    }

    @Deprecated
    public static IntTriPredicate between() {
        return IntTriCondition.BETWEEN;
    }

    @Deprecated
    public static IntTriPredicate betweenClosed() {
        return IntTriCondition.BETWEEN_CLOSED;
    }

    @Deprecated
    public static IntTriPredicate betweenZeroAndReserving() {
        return IntTriCondition.BETWEEN_ZERO_AND_ENSURING;
    }
}

