/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.internal.CloseableUtils;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceChangeListener;
import net.openhft.chronicle.core.io.ReferenceChangeListenerManager;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.NotNull;

public final class TracingReferenceCounted
implements MonitorReferenceCounted {
    private final Map<ReferenceOwner, StackTrace> references = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<ReferenceOwner, StackTrace> releases = Collections.synchronizedMap(new IdentityHashMap());
    private final Runnable onRelease;
    private final String uniqueId;
    private final Class<?> type;
    private final StackTrace createdHere;
    private final ReferenceChangeListenerManager referenceChangeListeners;
    private volatile StackTrace releasedHere;
    private boolean unmonitored;

    TracingReferenceCounted(Runnable onRelease, String uniqueId, Class<?> type) {
        this.onRelease = onRelease;
        this.uniqueId = uniqueId;
        this.type = type;
        this.createdHere = this.stackTrace("init", INIT);
        this.references.put(INIT, this.createdHere);
        this.referenceChangeListeners = new ReferenceChangeListenerManager(this);
    }

    @Override
    public StackTrace createdHere() {
        return this.createdHere;
    }

    @Override
    public void addReferenceChangeListener(ReferenceChangeListener referenceChangeListener) {
        this.referenceChangeListeners.add(referenceChangeListener);
    }

    @Override
    public void removeReferenceChangeListener(ReferenceChangeListener referenceChangeListener) {
        this.referenceChangeListeners.remove(referenceChangeListener);
    }

    @Override
    @Deprecated
    public boolean reservedBy(ReferenceOwner owner) throws IllegalStateException {
        if (this.references.containsKey(owner)) {
            return true;
        }
        StackTrace stackTrace = this.releases.get(owner);
        if (stackTrace == null) {
            throw new IllegalStateException(this.type.getName() + " never reserved by " + CloseableUtils.asString(owner));
        }
        throw new IllegalStateException(this.type.getName() + " no longer reserved by " + CloseableUtils.asString(owner), stackTrace);
    }

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        this.tryReserve(id, true);
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws IllegalStateException, IllegalArgumentException {
        return this.tryReserve(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryReserve(ReferenceOwner id, boolean must) throws IllegalStateException {
        if (id == this) {
            throw new AssertionError((Object)(this.type.getName() + " the counter cannot reserve itself"));
        }
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.isEmpty()) {
                if (must) {
                    throw new ClosedIllegalStateException(this.type.getName() + " cannot reserve freed resource", this.createdHere);
                }
                return false;
            }
            StackTrace stackTrace = this.references.get(id);
            if (stackTrace != null) {
                throw new IllegalStateException(this.type.getName() + " already reserved resource by " + CloseableUtils.asString(id) + " here", stackTrace);
            }
            this.references.put(id, this.stackTrace("reserve", id));
        }
        this.referenceChangeListeners.notifyAdded(id);
        this.releases.remove(id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        boolean doOnRelease = false;
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.remove(id) == null) {
                throw this.throwInvalidReleaseException(id);
            }
            this.releases.put(id, this.stackTrace("release", id));
            if (this.references.isEmpty()) {
                doOnRelease = true;
            }
        }
        this.referenceChangeListeners.notifyRemoved(id);
        if (doOnRelease) {
            if (this.releasedHere != null) {
                throw new IllegalStateException(this.type.getName() + " already released", this.releasedHere);
            }
            this.onRelease.run();
            this.releasedHere = new StackTrace(this.type.getName() + " released here");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            StackTrace stackTrace = this.references.get(to);
            if (stackTrace != null) {
                throw new IllegalStateException(this.type.getName() + " already reserved resource by " + CloseableUtils.asString(to) + " here", stackTrace);
            }
            if (this.references.remove(from) == null) {
                throw this.throwInvalidReleaseException(from);
            }
            this.releases.put(from, this.stackTrace("reserveTransfer", from));
            this.references.put(to, this.stackTrace("reserveTransfer", to));
            this.releases.remove(to);
        }
        this.referenceChangeListeners.notifyTransferred(from, to);
    }

    private IllegalStateException throwInvalidReleaseException(ReferenceOwner id) {
        StackTrace stackTrace = this.releases.get(id);
        if (stackTrace == null) {
            Throwable cause = this.createdHere;
            if (!this.references.isEmpty()) {
                StackTrace ste = this.references.values().iterator().next();
                cause = new IllegalStateException(this.type.getName() + " reserved by " + this.referencesAsString(), ste);
            }
            throw new IllegalStateException(this.type.getName() + " not reserved by " + CloseableUtils.asString(id), cause);
        }
        throw new ClosedIllegalStateException(this.type.getName() + " already released " + CloseableUtils.asString(id) + " location ", stackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> referencesAsString() {
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            return this.references.keySet().stream().map(CloseableUtils::asString).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        Exception e0 = null;
        try {
            this.release(id);
        }
        catch (Exception e) {
            e0 = e;
        }
        if (this.references.size() > 0) {
            IllegalStateException ise = new IllegalStateException(this.type.getName() + " still reserved " + this.referencesAsString(), this.createdHere);
            Map<ReferenceOwner, StackTrace> map = this.references;
            synchronized (map) {
                this.references.values().forEach(ise::addSuppressed);
            }
            if (e0 != null) {
                ise.addSuppressed(e0);
            }
            throw ise;
        }
        if (e0 != null) {
            Jvm.rethrow(e0);
        }
        this.referenceChangeListeners.clear();
    }

    @Override
    public int refCount() {
        return this.references.size();
    }

    @NotNull
    public String toString() {
        return this.uniqueId + " - " + this.referencesAsString();
    }

    @NotNull
    private StackTrace stackTrace(String oper, ReferenceOwner ro) {
        return new StackTrace(this.uniqueId + " " + Thread.currentThread().getName() + " " + oper + " " + CloseableUtils.asString(ro));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void throwExceptionIfNotReleased() throws IllegalStateException {
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.isEmpty()) {
                return;
            }
            ClosedIllegalStateException ise = new ClosedIllegalStateException(this.type.getName() + " retained reference closed");
            for (Map.Entry<ReferenceOwner, StackTrace> entry : this.references.entrySet()) {
                ReferenceOwner referenceOwner = entry.getKey();
                IllegalStateException ise2 = this.generateIllegalStateException(referenceOwner, entry.getValue());
                ise.addSuppressed(ise2);
                if (referenceOwner instanceof AbstractCloseable) {
                    this.addCloseableSuppressed(ise, (AbstractCloseable)referenceOwner);
                    continue;
                }
                if (!(referenceOwner instanceof ManagedCloseable)) continue;
                this.addManagedCloseableSuppressed(ise, (ManagedCloseable)((Object)referenceOwner));
            }
            if (ise.getSuppressed().length > 0) {
                throw ise;
            }
        }
    }

    private IllegalStateException generateIllegalStateException(ReferenceOwner referenceOwner, StackTrace reservedHere) {
        IllegalStateException ise2 = new IllegalStateException(this.type.getName() + " reserved by " + CloseableUtils.asString(referenceOwner), reservedHere);
        if (referenceOwner instanceof Closeable) {
            try {
                ((ManagedCloseable)((Object)referenceOwner)).throwExceptionIfClosed();
            }
            catch (IllegalStateException ise3) {
                ise2.addSuppressed(ise3);
            }
        } else if (referenceOwner instanceof AbstractReferenceCounted) {
            try {
                ((AbstractReferenceCounted)referenceOwner).throwExceptionIfReleased();
            }
            catch (IllegalStateException ise3) {
                ise2.addSuppressed(ise3);
            }
        }
        return ise2;
    }

    private void addCloseableSuppressed(IllegalStateException ise, AbstractCloseable ac) {
        try {
            ac.throwExceptionIfClosed();
        }
        catch (IllegalStateException e) {
            ise.addSuppressed(e);
        }
    }

    private void addManagedCloseableSuppressed(IllegalStateException ise, ManagedCloseable mc) {
        try {
            mc.throwExceptionIfClosed();
        }
        catch (Throwable t) {
            ise.addSuppressed(new ClosedIllegalStateException(this.type.getName() + " closed " + CloseableUtils.asString(mc), t));
        }
    }

    @Override
    public void throwExceptionIfReleased() throws ClosedIllegalStateException {
        if (this.refCount() <= 0) {
            throw new ClosedIllegalStateException(this.type.getName() + " released", this.releasedHere);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warnAndReleaseIfNotReleased() {
        boolean runOnRelease = false;
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.refCount() > 0) {
                if (!this.unmonitored && !AbstractCloseable.DISABLE_DISCARD_WARNING) {
                    Jvm.warn().on(this.type, "Discarded without being released by " + this.referencesAsString(), (Throwable)this.createdHere);
                }
                this.references.clear();
                runOnRelease = true;
            }
        }
        if (runOnRelease) {
            this.onRelease.run();
        }
    }

    @Override
    public void unmonitored(boolean unmonitored) {
        this.unmonitored = unmonitored;
    }

    @Override
    public boolean unmonitored() {
        return this.unmonitored;
    }
}

