/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import net.openhft.chronicle.core.onoes.ChainedExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.NullExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ThreadLocalisedExceptionHandler
implements ExceptionHandler {
    private ExceptionHandler eh;
    private ThreadLocal<ExceptionHandler> handlerTL;

    public ThreadLocalisedExceptionHandler(ExceptionHandler handler) {
        this.eh = handler;
        this.resetThreadLocalHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void on(@NotNull Class<?> clazz, @Nullable String message, @Nullable Throwable thrown) {
        ExceptionHandler exceptionHandler = this.exceptionHandler();
        if (exceptionHandler == null) {
            return;
        }
        boolean interrupted = Thread.interrupted();
        try {
            exceptionHandler.on(clazz, message, thrown);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void on(@NotNull Logger logger, @Nullable String message, Throwable thrown) {
        ExceptionHandler exceptionHandler = this.exceptionHandler();
        if (exceptionHandler == null) {
            return;
        }
        boolean interrupted = Thread.interrupted();
        try {
            exceptionHandler.on(logger, message, thrown);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ExceptionHandler exceptionHandler() {
        ExceptionHandler exceptionHandler = this.handlerTL.get();
        if (exceptionHandler == null) {
            exceptionHandler = this.eh;
        }
        return exceptionHandler;
    }

    @Override
    public ExceptionHandler defaultHandler() {
        return this.eh;
    }

    public static ExceptionHandler unwrap(ExceptionHandler eh) {
        if (eh instanceof ThreadLocalisedExceptionHandler) {
            return ((ThreadLocalisedExceptionHandler)eh).exceptionHandler();
        }
        return eh;
    }

    public ThreadLocalisedExceptionHandler defaultHandler(ExceptionHandler defaultHandler) {
        if ((defaultHandler = ThreadLocalisedExceptionHandler.unwrap(defaultHandler)) instanceof ChainedExceptionHandler) {
            ChainedExceptionHandler ceh = (ChainedExceptionHandler)defaultHandler;
            for (ExceptionHandler handler : ceh.chain()) {
                if (handler instanceof ThreadLocalisedExceptionHandler) {
                    throw new AssertionError((Object)("Recursive used of " + this.getClass()));
                }
            }
        }
        this.eh = defaultHandler == null ? NullExceptionHandler.NOTHING : defaultHandler;
        return this;
    }

    public ExceptionHandler threadLocalHandler() {
        return this.handlerTL.get();
    }

    public ThreadLocalisedExceptionHandler threadLocalHandler(ExceptionHandler handler) {
        this.handlerTL.set(handler);
        return this;
    }

    public void resetThreadLocalHandler() {
        this.handlerTL = new InheritableThreadLocal<ExceptionHandler>();
    }

    @Override
    public boolean isEnabled(@NotNull Class<?> aClass) {
        ExceptionHandler exceptionHandler = this.exceptionHandler();
        if (exceptionHandler == null) {
            return true;
        }
        return exceptionHandler.isEnabled(aClass);
    }
}

