/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Collections;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractReferenceCounted
implements ReferenceCountedTracer,
ReferenceOwner {
    protected static final long WARN_NS = (long)(Jvm.getDouble("reference.warn.secs", 0.003) * 1.0E9);
    protected static final int WARN_COUNT = Jvm.getInteger("reference.warn.count", Integer.MAX_VALUE);
    static volatile Set<AbstractReferenceCounted> referenceCountedSet;
    protected final transient MonitorReferenceCounted referenceCounted;
    private final int referenceId;
    private volatile transient Thread usedByThread;
    private volatile transient StackTrace usedByThreadHere;
    private boolean singleThreadedCheckDisabled;

    protected AbstractReferenceCounted() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractReferenceCounted(boolean monitored) {
        Runnable performRelease = BackgroundResourceReleaser.BG_RELEASER && this.canReleaseInBackground() ? this::backgroundPerformRelease : this::inThreadPerformRelease;
        this.referenceId = IOTools.counter(this.getClass()).incrementAndGet();
        this.referenceCounted = (MonitorReferenceCounted)ReferenceCountedTracer.onReleased(performRelease, this::referenceName, this.getClass());
        this.referenceCounted.unmonitored(!monitored);
        Set<AbstractReferenceCounted> set = referenceCountedSet;
        if (monitored && set != null) {
            Set<AbstractReferenceCounted> set2 = set;
            synchronized (set2) {
                set.add(this);
            }
        }
    }

    public static void enableReferenceTracing() {
        AbstractCloseable.enableCloseableTracing();
        referenceCountedSet = Collections.newSetFromMap(new WeakIdentityHashMap());
    }

    public static void disableReferenceTracing() {
        AbstractCloseable.disableCloseableTracing();
        referenceCountedSet = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertReferencesReleased() {
        Set<AbstractReferenceCounted> traceSet = referenceCountedSet;
        if (traceSet == null) {
            Jvm.warn().on(AbstractReferenceCounted.class, "Reference tracing disabled");
            return;
        }
        AbstractCloseable.assertCloseablesClosed();
        AssertionError openFiles = new AssertionError((Object)"Reference counted not released");
        Set<AbstractReferenceCounted> set = traceSet;
        synchronized (set) {
            for (AbstractReferenceCounted key : traceSet) {
                if (key == null || key.refCount() == 0) continue;
                try {
                    key.throwExceptionIfNotReleased();
                }
                catch (Exception e) {
                    ((Throwable)((Object)openFiles)).addSuppressed(e);
                }
            }
        }
        if (((Throwable)((Object)openFiles)).getSuppressed().length > 0) {
            throw openFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmonitor(ReferenceCounted counted) {
        Set<AbstractReferenceCounted> set = referenceCountedSet;
        if (counted instanceof AbstractReferenceCounted) {
            if (set != null) {
                Set<AbstractReferenceCounted> set2 = set;
                synchronized (set2) {
                    set.remove(counted);
                }
            }
            ((AbstractReferenceCounted)counted).referenceCounted.unmonitored(true);
        }
    }

    @Override
    public int referenceId() {
        return this.referenceId;
    }

    @Override
    public StackTrace createdHere() {
        return this.referenceCounted.createdHere();
    }

    @Override
    public void throwExceptionIfNotReleased() throws IllegalStateException {
        this.referenceCounted.throwExceptionIfNotReleased();
    }

    protected void backgroundPerformRelease() {
        BackgroundResourceReleaser.release(this);
    }

    void inThreadPerformRelease() {
        long start = System.nanoTime();
        try {
            this.performRelease();
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), e);
        }
        long time = System.nanoTime() - start;
        if (time >= WARN_NS) {
            Slf4jExceptionHandler.PERF.on(this.getClass(), "Took " + (double)(time / 100000L) / 10.0 + " ms to performRelease");
        }
    }

    protected boolean canReleaseInBackground() {
        return false;
    }

    protected abstract void performRelease() throws IllegalStateException;

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        if (WARN_COUNT < Integer.MAX_VALUE && this.referenceCounted.refCount() >= WARN_COUNT && (this.referenceCounted.refCount() - WARN_COUNT) % 10 == 0) {
            Jvm.warn().on(this.getClass(), "high reserve count for " + this.referenceName() + " was " + this.referenceCounted.refCount(), new StackTrace("reserved here"));
        }
        this.referenceCounted.reserve(id);
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.release(id);
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.releaseLast(id);
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws IllegalStateException, IllegalArgumentException {
        return this.referenceCounted.tryReserve(id);
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.referenceCounted.reserveTransfer(from, to);
    }

    @Override
    public int refCount() {
        return this.referenceCounted.refCount();
    }

    @Override
    public void throwExceptionIfReleased() throws ClosedIllegalStateException {
        this.referenceCounted.throwExceptionIfReleased();
    }

    @Override
    public void warnAndReleaseIfNotReleased() throws ClosedIllegalStateException {
        this.referenceCounted.warnAndReleaseIfNotReleased();
    }

    @Override
    public boolean reservedBy(ReferenceOwner owner) throws IllegalStateException {
        return this.referenceCounted.reservedBy(owner);
    }

    public void singleThreadedCheckDisabled(boolean singleThreadedCheckDisabled) {
        this.singleThreadedCheckDisabled = singleThreadedCheckDisabled;
    }

    protected boolean threadSafetyCheck(boolean isUsed) throws IllegalStateException {
        if (AbstractCloseable.DISABLE_SINGLE_THREADED_CHECK || this.singleThreadedCheckDisabled) {
            return true;
        }
        return this.threadSafetyCheck0(isUsed);
    }

    private boolean threadSafetyCheck0(boolean isUsed) {
        if (this.usedByThread == null && !isUsed) {
            return true;
        }
        Thread currentThread = Thread.currentThread();
        if (this.usedByThread == currentThread) {
            return true;
        }
        return this.threadSafetyCheck2(currentThread);
    }

    private boolean threadSafetyCheck2(Thread currentThread) {
        if (this.usedByThread == null || !this.usedByThread.isAlive()) {
            this.usedByThread = currentThread;
            this.usedByThreadHere = new StackTrace("Used here");
            return true;
        }
        String message = this.getClass().getName() + " component which is not thread safe used by " + this.usedByThread + " and " + currentThread;
        throw new IllegalStateException(message, this.usedByThreadHere);
    }

    public void singleThreadedCheckReset() {
        this.usedByThread = null;
    }

    @Deprecated
    public void clearUsedByThread() {
        this.usedByThread = null;
    }

    @NotNull
    public String toString() {
        return this.referenceName();
    }
}

