/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Bootstrap;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class UnsafeMemory
implements Memory {
    @NotNull
    public static final Unsafe UNSAFE;
    public static final UnsafeMemory INSTANCE;
    public static final UnsafeMemory MEMORY;
    @Deprecated
    public static final boolean tracing = false;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final String MIS_ALIGNED = "mis-aligned";
    public static final boolean IS_LITTLE_ENDIAN;
    private final AtomicLong nativeMemoryUsed = new AtomicLong();

    private static int retryReadVolatileInt(long address, int value) {
        int value2 = UNSAFE.getIntVolatile(null, address);
        while (value2 != value) {
            if (value != 0 && value != Integer.MIN_VALUE) {
                Jvm.warn().on(UnsafeMemory.class, "Int@" + Long.toHexString(address) + " (" + (address & 0x3FL) + ") was " + Integer.toHexString(value) + " is now " + Integer.toHexString(value2));
            }
            value = value2;
            value2 = UNSAFE.getIntVolatile(null, address);
        }
        return value;
    }

    private static long retryReadVolatileLong(long address, long value) {
        long value2 = UNSAFE.getLongVolatile(null, address);
        while (value2 != value) {
            if (value != 0L) {
                Jvm.warn().on(UnsafeMemory.class, "please add padding() when using concurrent writers, Long@" + Long.toHexString(address) + " (" + (address & 0x3FL) + ") was " + Long.toHexString(value) + " is now " + Long.toHexString(value2));
            }
            value = value2;
            value2 = UNSAFE.getLongVolatile(null, address);
        }
        return value;
    }

    public static void putInt(byte[] bytes, int offset, int value) {
        UNSAFE.putInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, value);
    }

    public static void unsafeStoreFence() {
        UNSAFE.storeFence();
    }

    public static void unsafeLoadFence() {
        UNSAFE.loadFence();
    }

    public static long unsafeGetLong(long address) {
        return UNSAFE.getLong(address);
    }

    public static int unsafeGetInt(long address) {
        return UNSAFE.getInt(address);
    }

    public static byte unsafeGetByte(long address) {
        return UNSAFE.getByte(address);
    }

    public static void unsafePutLong(long address, long value) {
        UNSAFE.putLong(address, value);
    }

    public static void unsafePutInt(long address, int value) {
        UNSAFE.putInt(address, value);
    }

    public static void unsafePutByte(long address, byte value) {
        UNSAFE.putByte(address, value);
    }

    public static void unsafePutLong(byte[] bytes, int offset, long value) {
        UNSAFE.putLong(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, value);
    }

    public static void unsafePutInt(byte[] bytes, int offset, int value) {
        UNSAFE.putInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, value);
    }

    public static void unsafePutByte(byte[] bytes, int offset, byte value) {
        UNSAFE.putByte(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, value);
    }

    public static void copyMemory(long from, long to, int length) {
        int i;
        for (i = 0; i < length - 7; i += 8) {
            UnsafeMemory.unsafePutLong(to + (long)i, UnsafeMemory.unsafeGetLong(from + (long)i));
        }
        if (i < length - 3) {
            UnsafeMemory.unsafePutInt(to + (long)i, UnsafeMemory.unsafeGetInt(from + (long)i));
            i += 4;
        }
        while (i < length) {
            UnsafeMemory.unsafePutByte(to + (long)i, UnsafeMemory.unsafeGetByte(from + (long)i));
            ++i;
        }
    }

    public static void unsafePutBoolean(@NotNull Object obj, long offset, boolean value) {
        UNSAFE.putBoolean(obj, offset, value);
    }

    public static boolean unsafeGetBoolean(@NotNull Object obj, long offset) {
        return UNSAFE.getBoolean(obj, offset);
    }

    public static void unsafePutByte(@NotNull Object obj, long offset, byte value) {
        UNSAFE.putByte(obj, offset, value);
    }

    public static byte unsafeGetByte(@NotNull Object obj, long offset) {
        return UNSAFE.getByte(obj, offset);
    }

    public static void unsafePutChar(@NotNull Object obj, long offset, char value) {
        UNSAFE.putChar(obj, offset, value);
    }

    public static char unsafeGetChar(@NotNull Object obj, long offset) {
        return UNSAFE.getChar(obj, offset);
    }

    public static void unsafePutShort(@NotNull Object obj, long offset, short value) {
        UNSAFE.putShort(obj, offset, value);
    }

    public static short unsafeGetShort(@NotNull Object obj, long offset) {
        return UNSAFE.getShort(obj, offset);
    }

    public static void unsafePutInt(@NotNull Object obj, long offset, int value) {
        UNSAFE.putInt(obj, offset, value);
    }

    public static int unsafeGetInt(@NotNull Object obj, long offset) {
        return UNSAFE.getInt(obj, offset);
    }

    public static void unsafePutFloat(@NotNull Object obj, long offset, float value) {
        UNSAFE.putFloat(obj, offset, value);
    }

    public static float unsafeGetFloat(@NotNull Object obj, long offset) {
        return UNSAFE.getFloat(obj, offset);
    }

    public static void unsafePutLong(@NotNull Object obj, long offset, long value) {
        UNSAFE.putLong(obj, offset, value);
    }

    public static long unsafeGetLong(@NotNull Object obj, long offset) {
        return UNSAFE.getLong(obj, offset);
    }

    public static void unsafePutDouble(@NotNull Object obj, long offset, double value) {
        UNSAFE.putDouble(obj, offset, value);
    }

    public static double unsafeGetDouble(@NotNull Object obj, long offset) {
        return UNSAFE.getDouble(obj, offset);
    }

    public static void unsafePutObject(@NotNull Object obj, long offset, Object value) {
        UNSAFE.putObject(obj, offset, value);
    }

    public static <T> T unsafeGetObject(@NotNull Object obj, long offset) {
        return (T)UNSAFE.getObject(obj, offset);
    }

    public static long unsafeObjectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    @Override
    @NotNull
    public <E> E allocateInstance(Class<? extends E> clazz) throws InstantiationException {
        @NotNull Object e = UNSAFE.allocateInstance(clazz);
        return (E)e;
    }

    @Override
    public long getFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    @Override
    public void setInt(@NotNull Object object, long offset, int value) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putInt(object, offset, value);
    }

    @Override
    @NotNull
    public <T> T getObject(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return (T)UNSAFE.getObject(object, offset);
    }

    @Override
    @ForceInline
    public void storeFence() {
        UNSAFE.storeFence();
    }

    @Override
    @ForceInline
    public void loadFence() {
        UNSAFE.loadFence();
    }

    @Override
    @ForceInline
    public void setMemory(long address, long size, byte b) {
        UNSAFE.setMemory(address, size, b);
    }

    @Override
    public void freeMemory(long address, long size) {
        if (address != 0L) {
            UNSAFE.freeMemory(address);
        }
        this.nativeMemoryUsed.addAndGet(-size);
    }

    @Override
    public long allocate(long capacity) {
        if (capacity <= 0L) {
            throw new AssertionError((Object)("Invalid capacity: " + capacity));
        }
        long address = UNSAFE.allocateMemory(capacity);
        if (address == 0L) {
            throw new OutOfMemoryError("Not enough free native memory, capacity attempted: " + capacity / 1024L + " KiB");
        }
        this.nativeMemoryUsed.addAndGet(capacity);
        return address;
    }

    @Override
    public long nativeMemoryUsed() {
        return this.nativeMemoryUsed.get();
    }

    @Override
    @ForceInline
    public void writeByte(long address, byte b) {
        UNSAFE.putByte(address, b);
    }

    @Override
    @ForceInline
    public void writeByte(@NotNull Object object, long offset, byte b) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putByte(object, offset, b);
    }

    @Override
    @ForceInline
    public byte readByte(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getByte(object, offset);
    }

    @Override
    @ForceInline
    public void writeBytes(long address, byte[] b, int offset, int length) throws IllegalArgumentException {
        if (offset + length > b.length) {
            throw new IllegalArgumentException("Invalid offset or length, array's length is " + b.length);
        }
        UNSAFE.copyMemory(b, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, null, address, length);
    }

    @Override
    @ForceInline
    public void readBytes(long address, byte[] b, long offset, int length) throws IllegalArgumentException {
        if (offset + (long)length > (long)b.length) {
            throw new IllegalArgumentException("Invalid offset or length, array's length is " + b.length);
        }
        UNSAFE.copyMemory(null, address, b, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + offset, length);
    }

    @Override
    @ForceInline
    public byte readByte(long address) {
        return UNSAFE.getByte(address);
    }

    @Override
    @ForceInline
    public void writeShort(long address, short i16) {
        UNSAFE.putShort(address, i16);
    }

    @Override
    @ForceInline
    public void writeShort(@NotNull Object object, long offset, short i16) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putShort(object, offset, i16);
    }

    @Override
    @ForceInline
    public short readShort(long address) {
        return UNSAFE.getShort(address);
    }

    @Override
    @ForceInline
    public short readShort(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getShort(object, offset);
    }

    @Override
    @ForceInline
    public void writeInt(long address, int i32) {
        UNSAFE.putInt(address, i32);
    }

    @Override
    @ForceInline
    public void writeInt(@NotNull Object object, long offset, int i32) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putInt(object, offset, i32);
    }

    @Override
    @ForceInline
    public void writeOrderedInt(long address, int i32) {
        UNSAFE.putOrderedInt(null, address, i32);
    }

    @Override
    @ForceInline
    public void writeOrderedInt(@NotNull Object object, long offset, int i32) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putOrderedInt(object, offset, i32);
    }

    @Override
    @ForceInline
    public int readInt(long address) {
        return UNSAFE.getInt(address);
    }

    @Override
    @ForceInline
    public int readInt(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getInt(object, offset);
    }

    @Override
    @ForceInline
    public void writeLong(long address, long i64) {
        UNSAFE.putLong(address, i64);
    }

    @Override
    @ForceInline
    public void writeLong(@NotNull Object object, long offset, long i64) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putLong(object, offset, i64);
    }

    @Override
    @ForceInline
    public long readLong(long address) {
        return UNSAFE.getLong(address);
    }

    @Override
    @ForceInline
    public long readLong(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getLong(object, offset);
    }

    @Override
    @ForceInline
    public void writeFloat(long address, float f) {
        UNSAFE.putFloat(address, f);
    }

    @Override
    @ForceInline
    public void writeFloat(@NotNull Object object, long offset, float f) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putFloat(object, offset, f);
    }

    @Override
    @ForceInline
    public float readFloat(long address) {
        return UNSAFE.getFloat(address);
    }

    @Override
    @ForceInline
    public float readFloat(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getFloat(object, offset);
    }

    @Override
    @ForceInline
    public void writeDouble(long address, double d) {
        UNSAFE.putDouble(address, d);
    }

    @Override
    @ForceInline
    public void writeDouble(@NotNull Object object, long offset, double d) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putDouble(object, offset, d);
    }

    @Override
    @ForceInline
    public double readDouble(long address) {
        return UNSAFE.getDouble(address);
    }

    @Override
    @ForceInline
    public double readDouble(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getDouble(object, offset);
    }

    @Override
    @ForceInline
    public void copyMemory(byte[] bytes, int offset, long address, int length) {
        int i;
        long offset2 = (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset;
        for (i = 0; i < length - 7; i += 8) {
            UnsafeMemory.unsafePutLong(address + (long)i, UnsafeMemory.unsafeGetLong(bytes, offset2 + (long)i));
        }
        if (i < length - 3) {
            UnsafeMemory.unsafePutInt(address + (long)i, UnsafeMemory.unsafeGetInt(bytes, offset2 + (long)i));
            i += 4;
        }
        while (i < length) {
            UnsafeMemory.unsafePutByte(address + (long)i, UnsafeMemory.unsafeGetByte(bytes, offset2 + (long)i));
            ++i;
        }
    }

    @Override
    @ForceInline
    public void copyMemory(long fromAddress, long address, long length) {
        if (length < 0x100000L) {
            UNSAFE.copyMemory(null, fromAddress, null, address, length);
        } else {
            this.copyMemory0(null, fromAddress, null, address, length);
        }
    }

    @Override
    public void copyMemory(byte[] bytes, int offset, Object obj2, long offset2, int length) {
        if (obj2 instanceof byte[]) {
            this.copyMemory(bytes, offset, (byte[])obj2, Math.toIntExact(offset2 - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), length);
        } else {
            this.copyMemoryLoop(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, obj2, offset2, length);
        }
    }

    public void copyMemory(byte[] bytes, int offset, byte[] obj2, int offset2, int length) {
        long offsetB = (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset;
        long offset2B = (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset2;
        if ((long)length < 0x100000L) {
            UNSAFE.copyMemory(bytes, offsetB, obj2, offset2B, length);
        } else {
            this.copyMemory0(bytes, offsetB, obj2, offset2B, length);
        }
    }

    @Override
    public void copyMemory(Object o, long offset, Object o2, long offset2, int length) {
        if (o instanceof byte[]) {
            this.copyMemory((byte[])o, Math.toIntExact(offset - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), o2, offset2, length);
        } else {
            this.copyMemoryLoop(o, offset, o2, offset2, length);
        }
    }

    private void copyMemoryLoop(Object o, long offset, Object o2, long offset2, int length) {
        int i;
        if (o == o2 && offset < offset2) {
            this.backwardCopyMemoryLoop(o, offset, o2, offset2, length);
            return;
        }
        for (i = 0; i < length - 7; i += 8) {
            UNSAFE.putLong(o2, offset2 + (long)i, UNSAFE.getLong(o, offset + (long)i));
        }
        while (i < length) {
            UNSAFE.putByte(o2, offset2 + (long)i, UNSAFE.getByte(o, offset + (long)i));
            ++i;
        }
    }

    private void backwardCopyMemoryLoop(Object o, long offset, Object o2, long offset2, int length) {
        int i;
        offset += (long)length;
        offset2 += (long)length;
        for (i = 0; i < length - 7; i += 8) {
            UNSAFE.putLong(o2, offset2 - 8L - (long)i, UNSAFE.getLong(o, offset - 8L - (long)i));
        }
        while (i < length) {
            byte aByte = UNSAFE.getByte(o, offset - 1L - (long)i);
            System.out.println((char)aByte);
            UNSAFE.putByte(o2, offset2 - 1L - (long)i, aByte);
            ++i;
        }
    }

    @Override
    @ForceInline
    public void copyMemory(long fromAddress, Object obj2, long offset2, int length) {
        long time;
        long start = length > 131072 ? System.nanoTime() : 0L;
        this.copyMemory0(null, fromAddress, obj2, offset2, length);
        if (length > 131072 && (time = System.nanoTime() - start) > 100000L) {
            Jvm.perf().on(this.getClass(), "Took " + (double)(time / 1000L) / 1000.0 + " ms to copy " + length / 1024 + " KB");
        }
    }

    void copyMemory0(Object from, long fromOffset, Object to, long toOffset, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            UNSAFE.copyMemory(from, fromOffset, to, toOffset, size);
            length -= size;
            fromOffset += size;
            toOffset += size;
        }
    }

    @Override
    public int stopBitLength(int i) {
        if ((i & 0xFFFFFF80) == 0) {
            return 1;
        }
        return this.stopBitLength0(i);
    }

    private int stopBitLength0(int i) {
        if (i < 0) {
            return 1 + this.stopBitLength(~i);
        }
        return (38 - Integer.numberOfLeadingZeros(i)) / 7;
    }

    @Override
    public int stopBitLength(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        return this.stopBitLength0(l);
    }

    private int stopBitLength0(long l) {
        if (l < 0L) {
            return 1 + this.stopBitLength(l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return (70 - Long.numberOfLeadingZeros(l)) / 7;
    }

    @Override
    public long partialRead(byte[] bytes, int offset, int length) {
        switch (length) {
            case 8: {
                return UNSAFE.getLong(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset);
            }
            case 4: {
                return (long)UNSAFE.getInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset) & 0xFFFFFFFFL;
            }
            case 2: {
                return UNSAFE.getShort(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset) & 0xFFFF;
            }
            case 1: {
                return bytes[offset] & 0xFF;
            }
            case 0: {
                return 0L;
            }
        }
        long value = 0L;
        offset += length;
        if ((length & 4) != 0) {
            value = (long)UNSAFE.getInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)(offset -= 4)) & 0xFFFFFFFFL;
        }
        if ((length & 2) != 0) {
            value <<= 16;
            int s = UNSAFE.getShort(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)(offset -= 2)) & 0xFFFF;
            value |= (long)s;
        }
        if ((length & 1) != 0) {
            value <<= 8;
            int b = bytes[--offset] & 0xFF;
            value |= (long)b;
        }
        return value;
    }

    @Override
    public long partialRead(long addr, int length) {
        switch (length) {
            case 8: {
                return UNSAFE.getLong(addr);
            }
            case 4: {
                return (long)UNSAFE.getInt(addr) & 0xFFFFFFFFL;
            }
            case 2: {
                return UNSAFE.getShort(addr) & 0xFFFF;
            }
            case 1: {
                return UNSAFE.getByte(addr) & 0xFF;
            }
            case 0: {
                return 0L;
            }
        }
        long value = 0L;
        addr += (long)length;
        if ((length & 4) != 0) {
            value = (long)UNSAFE.getInt(addr -= 4L) & 0xFFFFFFFFL;
        }
        if ((length & 2) != 0) {
            value <<= 16;
            int s = UNSAFE.getShort(addr -= 2L) & 0xFFFF;
            value |= (long)s;
        }
        if ((length & 1) != 0) {
            value <<= 8;
            int b = UNSAFE.getByte(--addr) & 0xFF;
            value |= (long)b;
        }
        return value;
    }

    @Override
    public void partialWrite(byte[] bytes, int offset, long value, int length) {
        switch (length) {
            case 8: {
                UNSAFE.putLong(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, value);
                return;
            }
            case 4: {
                UNSAFE.putInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, (int)value);
                return;
            }
            case 2: {
                UNSAFE.putShort(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, (short)value);
                return;
            }
            case 1: {
                UNSAFE.putByte(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, (byte)value);
                return;
            }
            case 0: {
                return;
            }
        }
        if ((length & 1) != 0) {
            UNSAFE.putByte(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, (byte)value);
            ++offset;
            value >>>= 8;
        }
        if ((length & 2) != 0) {
            UNSAFE.putShort(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, (short)value);
            offset += 2;
            value >>>= 16;
        }
        if ((length & 4) != 0) {
            UNSAFE.putInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset, (int)value);
        }
    }

    @Override
    public void partialWrite(long addr, long value, int length) {
        switch (length) {
            case 8: {
                UNSAFE.putLong(addr, value);
                return;
            }
            case 4: {
                UNSAFE.putInt(addr, (int)value);
                return;
            }
            case 2: {
                UNSAFE.putShort(addr, (short)value);
                return;
            }
            case 1: {
                UNSAFE.putByte(addr, (byte)value);
                return;
            }
            case 0: {
                return;
            }
        }
        if ((length & 1) != 0) {
            UNSAFE.putByte(addr, (byte)value);
            ++addr;
            value >>>= 8;
        }
        if ((length & 2) != 0) {
            UNSAFE.putShort(addr, (short)value);
            addr += 2L;
            value >>>= 16;
        }
        if ((length & 4) != 0) {
            UNSAFE.putInt(addr, (int)value);
        }
    }

    @Override
    public boolean is7Bit(byte[] bytes, int offset, int length) {
        int i;
        long offset2 = (long)offset + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
        for (i = 0; i < length - 7; i += 8) {
            if ((UNSAFE.getLong(bytes, offset2 + (long)i) & 0x8080808080808080L) == 0L) continue;
            return false;
        }
        if (i < length - 3) {
            if ((UNSAFE.getInt(bytes, offset2 + (long)i) & 0x80808080) != 0) {
                return false;
            }
            i += 4;
        }
        if (i < length - 1) {
            if ((UNSAFE.getShort(bytes, offset2 + (long)i) & 0x8080) != 0) {
                return false;
            }
            i += 2;
        }
        if (i < length) {
            return UNSAFE.getByte(bytes, offset2 + (long)i) >= 0;
        }
        return true;
    }

    @Override
    public boolean is7Bit(char[] chars, int offset, int length) {
        int i;
        long offset2 = (long)offset * 2L + (long)Unsafe.ARRAY_CHAR_BASE_OFFSET;
        for (i = 0; i < length - 3; i += 4) {
            if ((UNSAFE.getLong(chars, offset2 + (long)i + (long)i) & 0xFF80FF80FF80FF80L) == 0L) continue;
            return false;
        }
        if (i < length - 1) {
            if ((UNSAFE.getInt(chars, offset2 + (long)i + (long)i) & 0xFF80FF80) != 0) {
                return false;
            }
            i += 2;
        }
        if (i < length) {
            return (UNSAFE.getChar(chars, offset2 + (long)i + (long)i) & 0xFF80) == 0;
        }
        return true;
    }

    @Override
    public boolean is7Bit(long address, int length) {
        int i;
        for (i = 0; i < length - 7; i += 8) {
            if ((UNSAFE.getLong(address + (long)i) & 0x8080808080808080L) == 0L) continue;
            return false;
        }
        if (i < length - 3) {
            if ((UNSAFE.getInt(address + (long)i) & 0x80808080) != 0) {
                return false;
            }
            i += 4;
        }
        if (i < length - 1) {
            if ((UNSAFE.getShort(address + (long)i) & 0x8080) != 0) {
                return false;
            }
            i += 2;
        }
        if (i < length) {
            return UNSAFE.getByte(address + (long)i) >= 0;
        }
        return true;
    }

    @Override
    @ForceInline
    public void writeOrderedLong(long address, long i) {
        UNSAFE.putOrderedLong(null, address, i);
    }

    @Override
    @ForceInline
    public void writeOrderedLong(@NotNull Object object, long offset, long i) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putOrderedLong(object, offset, i);
    }

    @Override
    public void testAndSetInt(long address, long offset, int expected, int value) throws IllegalStateException {
        assert ((address & 0x3FL) <= 60L);
        if (UNSAFE.compareAndSwapInt(null, address, expected, value)) {
            return;
        }
        int actual = UNSAFE.getIntVolatile(null, address);
        throw new IllegalStateException("Cannot change at " + offset + " expected " + expected + " was " + actual);
    }

    @Override
    public void testAndSetInt(@NotNull Object object, long offset, int expected, int value) throws IllegalStateException {
        if (UNSAFE.compareAndSwapInt(object, offset, expected, value)) {
            return;
        }
        int actual = UNSAFE.getIntVolatile(object, offset);
        throw new IllegalStateException("Cannot change " + object.getClass().getSimpleName() + " at " + offset + " expected " + expected + " was " + actual);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapInt(long address, int expected, int value) {
        assert ((address & 0x3FL) <= 60L);
        return UNSAFE.compareAndSwapInt(null, address, expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapInt(@NotNull Object object, long offset, int expected, int value) {
        assert ((offset & 0x3FL) <= 60L);
        ObjectUtils.requireNonNull(object);
        return UNSAFE.compareAndSwapInt(object, offset, expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapLong(long address, long expected, long value) {
        assert ((address & 0x3FL) <= 56L);
        return UNSAFE.compareAndSwapLong(null, address, expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapLong(@NotNull Object object, long offset, long expected, long value) {
        assert ((offset & 0x3FL) <= 56L);
        ObjectUtils.requireNonNull(object);
        return UNSAFE.compareAndSwapLong(object, offset, expected, value);
    }

    @Override
    public int pageSize() {
        return UNSAFE.pageSize();
    }

    @Override
    @ForceInline
    public byte readVolatileByte(long address) {
        return UNSAFE.getByteVolatile(null, address);
    }

    @Override
    @ForceInline
    public byte readVolatileByte(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getByteVolatile(object, offset);
    }

    @Override
    @ForceInline
    public short readVolatileShort(long address) {
        return UNSAFE.getShortVolatile(null, address);
    }

    @Override
    @ForceInline
    public short readVolatileShort(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getShortVolatile(object, offset);
    }

    @Override
    @ForceInline
    public int readVolatileInt(long address) {
        int value = UNSAFE.getIntVolatile(null, address);
        if ((address & 0x3FL) <= 60L) {
            if (value == 0) {
                value = UNSAFE.getIntVolatile(null, address);
            }
            return value;
        }
        return UnsafeMemory.retryReadVolatileInt(address, value);
    }

    @Override
    @ForceInline
    public int readVolatileInt(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getIntVolatile(object, offset);
    }

    @Override
    @ForceInline
    public float readVolatileFloat(long address) {
        return UNSAFE.getFloatVolatile(null, address);
    }

    @Override
    @ForceInline
    public float readVolatileFloat(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getFloatVolatile(object, offset);
    }

    @Override
    @ForceInline
    public long readVolatileLong(long address) {
        long value = UNSAFE.getLongVolatile(null, address);
        if ((address & 0x3FL) <= 56L) {
            return value;
        }
        return UnsafeMemory.retryReadVolatileLong(address, value);
    }

    @Override
    @ForceInline
    public long readVolatileLong(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getLongVolatile(object, offset);
    }

    @Override
    @ForceInline
    public double readVolatileDouble(long address) {
        return UNSAFE.getDoubleVolatile(null, address);
    }

    @Override
    @ForceInline
    public double readVolatileDouble(@NotNull Object object, long offset) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getDoubleVolatile(object, offset);
    }

    @Override
    @ForceInline
    public void writeVolatileByte(long address, byte b) {
        UNSAFE.putByteVolatile(null, address, b);
    }

    @Override
    @ForceInline
    public void writeVolatileByte(@NotNull Object object, long offset, byte b) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putByteVolatile(object, offset, b);
    }

    @Override
    @ForceInline
    public void writeVolatileShort(long address, short i16) {
        UNSAFE.putShortVolatile(null, address, i16);
    }

    @Override
    @ForceInline
    public void writeVolatileShort(@NotNull Object object, long offset, short i16) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putShortVolatile(object, offset, i16);
    }

    @Override
    @ForceInline
    public void writeVolatileInt(long address, int i32) {
        UNSAFE.putIntVolatile(null, address, i32);
    }

    @Override
    @ForceInline
    public void writeVolatileInt(@NotNull Object object, long offset, int i32) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putIntVolatile(object, offset, i32);
    }

    @Override
    @ForceInline
    public void writeVolatileFloat(long address, float f) {
        UNSAFE.putFloatVolatile(null, address, f);
    }

    @Override
    @ForceInline
    public void writeVolatileFloat(@NotNull Object object, long offset, float f) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putFloatVolatile(object, offset, f);
    }

    @Override
    @ForceInline
    public void writeVolatileLong(long address, long i64) {
        UNSAFE.putLongVolatile(null, address, i64);
    }

    @Override
    @ForceInline
    public void writeVolatileLong(@NotNull Object object, long offset, long i64) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putLongVolatile(object, offset, i64);
    }

    @Override
    @ForceInline
    public void writeVolatileDouble(long address, double d) {
        UNSAFE.putDoubleVolatile(null, address, d);
    }

    @Override
    @ForceInline
    public void writeVolatileDouble(@NotNull Object object, long offset, double d) {
        ObjectUtils.requireNonNull(object);
        UNSAFE.putDoubleVolatile(object, offset, d);
    }

    @Override
    @ForceInline
    public int addInt(long address, int increment) {
        return UNSAFE.getAndAddInt(null, address, increment) + increment;
    }

    @Override
    @ForceInline
    public int addInt(@NotNull Object object, long offset, int increment) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getAndAddInt(object, offset, increment) + increment;
    }

    @Override
    @ForceInline
    public long addLong(long address, long increment) {
        return UNSAFE.getAndAddLong(null, address, increment) + increment;
    }

    @Override
    @ForceInline
    public long addLong(@NotNull Object object, long offset, long increment) {
        ObjectUtils.requireNonNull(object);
        return UNSAFE.getAndAddLong(object, offset, increment) + increment;
    }

    public void copy8bit(String s, int start, int length, long addr) {
        if (CachedReflection.stringValueOffset == 0L) {
            this.copy8BitJava9(s, start, length, addr);
            return;
        }
        char[] chars = (char[])UNSAFE.getObject(s, CachedReflection.stringValueOffset);
        for (int i = 0; i < length; ++i) {
            UNSAFE.putByte(addr + (long)i, (byte)chars[start + i]);
        }
    }

    private void copy8BitJava9(String s, int start, int length, long addr) {
        for (int i = 0; i < length; ++i) {
            UNSAFE.putByte(addr + (long)i, (byte)s.charAt(start + i));
        }
    }

    public void write8bit(String s, int start, Object object, long offset, int length) {
        if (CachedReflection.stringValueOffset == 0L) {
            this.write8bitJava9(s, start, object, offset, length);
            return;
        }
        char[] chars = (char[])UNSAFE.getObject(s, CachedReflection.stringValueOffset);
        for (int i = 0; i < length; ++i) {
            UNSAFE.putByte(object, offset + (long)i, (byte)chars[start + i]);
        }
    }

    private void write8bitJava9(String s, int start, Object object, long offset, int length) {
        for (int i = 0; i < length; ++i) {
            UNSAFE.putByte(object, offset + (long)i, (byte)s.charAt(start + i));
        }
    }

    public boolean isEqual(long addr, String s, int length) {
        if (CachedReflection.stringValueOffset == 0L) {
            return this.isEqualJava9(addr, s, length);
        }
        char[] chars = (char[])UNSAFE.getObject(s, CachedReflection.stringValueOffset);
        for (int i = 0; i < length; ++i) {
            if (UNSAFE.getByte(addr + (long)i) == chars[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualJava9(long addr, String s, int length) {
        for (int i = 0; i < length; ++i) {
            if (UNSAFE.getByte(addr + (long)i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static {
        IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new AssertionError((Object)e);
        }
        MEMORY = INSTANCE = Bootstrap.isArm0() ? new ARMMemory() : new UnsafeMemory();
    }

    private static class ARMMemory
    extends UnsafeMemory {
        private ARMMemory() {
        }

        @Override
        public short readVolatileShort(long address) {
            if ((address & 1L) == 0L) {
                return super.readVolatileShort(address);
            }
            UNSAFE.loadFence();
            return super.readShort(address);
        }

        @Override
        public void writeVolatileShort(long address, short i16) {
            if ((address & 1L) == 0L) {
                super.writeVolatileShort(address, i16);
            } else {
                super.writeShort(address, i16);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeFloat(long address, float f) {
            if ((address & 3L) == 0L) {
                super.writeFloat(address, f);
            } else {
                super.writeInt(address, Float.floatToRawIntBits(f));
            }
        }

        @Override
        public float readFloat(long address) {
            if ((address & 3L) == 0L) {
                return super.readFloat(address);
            }
            return Float.intBitsToFloat(super.readInt(address));
        }

        @Override
        public void writeFloat(@NotNull Object object, long offset, float f) {
            if ((offset & 3L) == 0L) {
                super.writeFloat(object, offset, f);
            } else {
                super.writeInt(object, offset, Float.floatToRawIntBits(f));
            }
        }

        @Override
        public float readFloat(@NotNull Object object, long offset) {
            if ((offset & 3L) == 0L) {
                return super.readFloat(object, offset);
            }
            return Float.intBitsToFloat(super.readInt(object, offset));
        }

        @Override
        public int readVolatileInt(long address) {
            if ((address & 3L) == 0L) {
                return super.readVolatileInt(address);
            }
            UNSAFE.loadFence();
            return super.readInt(address);
        }

        @Override
        public float readVolatileFloat(long address) {
            if ((address & 3L) == 0L) {
                return super.readVolatileFloat(address);
            }
            UNSAFE.loadFence();
            return this.readFloat(address);
        }

        @Override
        public void writeVolatileInt(long address, int i32) {
            if ((address & 3L) == 0L) {
                super.writeVolatileInt(address, i32);
            } else {
                this.writeInt(address, i32);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeOrderedInt(long address, int i32) {
            if ((address & 3L) == 0L) {
                super.writeOrderedInt(address, i32);
            } else {
                this.writeVolatileInt(address, i32);
            }
        }

        @Override
        public void writeOrderedInt(@NotNull Object object, long offset, int i32) {
            if ((offset & 3L) == 0L) {
                super.writeOrderedInt(object, offset, i32);
            } else {
                super.writeVolatileInt(object, offset, i32);
            }
        }

        @Override
        public void writeVolatileFloat(long address, float f) {
            if ((address & 3L) == 0L) {
                super.writeVolatileFloat(address, f);
            } else {
                this.writeVolatileInt(address, Float.floatToRawIntBits(f));
            }
        }

        @Override
        public int addInt(long address, int increment) {
            if ((address & 3L) == 0L) {
                return super.addInt(address, increment);
            }
            throw new AssertionError((Object)UnsafeMemory.MIS_ALIGNED);
        }

        @Override
        public boolean compareAndSwapInt(long address, int expected, int value) {
            if ((address & 3L) == 0L) {
                return super.compareAndSwapInt(address, expected, value);
            }
            throw new AssertionError((Object)UnsafeMemory.MIS_ALIGNED);
        }

        @Override
        public boolean compareAndSwapInt(@NotNull Object object, long offset, int expected, int value) {
            if ((offset & 3L) == 0L) {
                return super.compareAndSwapInt(object, offset, expected, value);
            }
            throw new AssertionError((Object)UnsafeMemory.MIS_ALIGNED);
        }

        @Override
        public void testAndSetInt(long address, long offset, int expected, int value) throws IllegalStateException {
            if ((address & 0xFFFFFFFFFFFFFFFCL) == 0L) {
                if (UNSAFE.compareAndSwapInt(null, address, expected, value)) {
                    return;
                }
                int actual = UNSAFE.getIntVolatile(null, address);
                throw new IllegalStateException("Cannot change at " + offset + " expected " + expected + " was " + actual);
            }
            UNSAFE.loadFence();
            int actual = UNSAFE.getInt(address);
            if (actual == expected) {
                UNSAFE.putInt(address, value);
                UNSAFE.storeFence();
                return;
            }
            throw new IllegalStateException("Cannot perform thread safe operation at " + offset + " as mis-aligned");
        }

        @Override
        public void testAndSetInt(@NotNull Object object, long offset, int expected, int value) throws IllegalStateException {
            if ((offset & 0xFFFFFFFFFFFFFFFCL) == 0L) {
                if (UNSAFE.compareAndSwapInt(object, offset, expected, value)) {
                    return;
                }
                int actual = UNSAFE.getIntVolatile(object, offset);
                throw new IllegalStateException("Cannot change " + object.getClass().getSimpleName() + " at " + offset + " expected " + expected + " was " + actual);
            }
            UNSAFE.loadFence();
            int actual = UNSAFE.getInt(object, offset);
            if (actual == expected) {
                UNSAFE.putInt(object, offset, value);
                UNSAFE.storeFence();
                return;
            }
            throw new IllegalStateException("Cannot perform thread safe operation on " + object.getClass().getSimpleName() + " at " + offset + " as mis-aligned");
        }

        @Override
        public void writeDouble(long address, double d) {
            if ((address & 7L) == 0L) {
                super.writeDouble(address, d);
            } else {
                super.writeLong(address, Double.doubleToRawLongBits(d));
            }
        }

        @Override
        public double readDouble(long address) {
            if ((address & 7L) == 0L) {
                return super.readDouble(address);
            }
            return Double.longBitsToDouble(super.readLong(address));
        }

        @Override
        public void writeDouble(@NotNull Object object, long offset, double d) {
            if ((offset & 7L) == 0L) {
                super.writeDouble(object, offset, d);
            } else {
                super.writeLong(object, offset, Double.doubleToRawLongBits(d));
            }
        }

        @Override
        public double readDouble(@NotNull Object object, long offset) {
            if ((offset & 7L) == 0L) {
                return super.readDouble(object, offset);
            }
            return Double.longBitsToDouble(super.readLong(object, offset));
        }

        @Override
        public void writeOrderedLong(long address, long i) {
            if ((address & 7L) == 0L) {
                super.writeOrderedLong(address, i);
            } else {
                this.writeVolatileLong(address, i);
            }
        }

        @Override
        public long readVolatileLong(long address) {
            if ((address & 7L) == 0L) {
                return super.readVolatileLong(address);
            }
            UNSAFE.loadFence();
            return this.readLong(address);
        }

        @Override
        public void writeOrderedLong(@NotNull Object object, long offset, long i) {
            if ((offset & 7L) == 0L) {
                super.writeOrderedLong(object, offset, i);
            } else {
                this.writeVolatileLong(object, offset, i);
            }
        }

        @Override
        public long readVolatileLong(@NotNull Object object, long offset) {
            if ((offset & 7L) == 0L) {
                return super.readVolatileLong(object, offset);
            }
            UNSAFE.loadFence();
            return this.readLong(object, offset);
        }

        @Override
        public double readVolatileDouble(long address) {
            if ((address & 7L) == 0L) {
                return super.readVolatileDouble(address);
            }
            UNSAFE.loadFence();
            return this.readDouble(address);
        }

        @Override
        public void writeVolatileLong(@NotNull Object object, long offset, long i64) {
            if ((offset & 7L) == 0L) {
                super.writeVolatileLong(object, offset, i64);
            } else {
                this.writeLong(object, offset, i64);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeVolatileLong(long address, long i64) {
            if ((address & 7L) == 0L) {
                super.writeVolatileLong(address, i64);
            } else {
                this.writeLong(address, i64);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeVolatileDouble(long address, double d) {
            if ((address & 7L) == 0L) {
                super.writeVolatileDouble(address, d);
            } else {
                this.writeLong(address, Double.doubleToRawLongBits(d));
            }
        }

        @Override
        public long addLong(long address, long increment) {
            if ((address & 7L) == 0L) {
                return super.addLong(address, increment);
            }
            throw new AssertionError((Object)UnsafeMemory.MIS_ALIGNED);
        }

        @Override
        public boolean compareAndSwapLong(@NotNull Object object, long offset, long expected, long value) {
            if ((offset & 7L) == 0L) {
                return super.compareAndSwapLong(object, offset, expected, value);
            }
            throw new AssertionError((Object)UnsafeMemory.MIS_ALIGNED);
        }

        @Override
        public boolean compareAndSwapLong(long address, long expected, long value) {
            if ((address & 7L) == 0L) {
                return super.compareAndSwapLong(address, expected, value);
            }
            throw new AssertionError((Object)UnsafeMemory.MIS_ALIGNED);
        }
    }

    static class CachedReflection {
        private static final long stringValueOffset;

        CachedReflection() {
        }

        static {
            long offset = 0L;
            try {
                if (!Jvm.isJava9Plus()) {
                    Field valueField = String.class.getDeclaredField("value");
                    offset = UNSAFE.objectFieldOffset(valueField);
                }
            }
            catch (NoSuchFieldException e) {
                offset = 0L;
            }
            stringValueOffset = offset;
        }
    }
}

