/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import net.openhft.chronicle.core.annotation.Negative;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.annotation.NonPositive;
import net.openhft.chronicle.core.annotation.Positive;
import net.openhft.chronicle.core.annotation.Range;

public final class Ints {
    private Ints() {
    }

    public static int requirePositive(@Positive int val) throws IllegalArgumentException {
        if (val < 1) {
            throw new IllegalArgumentException(val + " is not positive.");
        }
        return val;
    }

    public static int requireNegative(@Negative int val) throws IllegalArgumentException {
        if (val > -1) {
            throw new IllegalArgumentException(val + " is not negative.");
        }
        return val;
    }

    public static int requireZero(int val) throws IllegalArgumentException {
        if (val != 0) {
            throw new IllegalArgumentException(val + " is not zero.");
        }
        return val;
    }

    public static int requireNonPositive(@NonPositive int val) throws IllegalArgumentException {
        if (val > 0) {
            throw new IllegalArgumentException(val + " is positive.");
        }
        return val;
    }

    public static int requireNonNegative(@NonNegative int val) throws IllegalArgumentException {
        if (val < 0) {
            throw new IllegalArgumentException(val + " is negative.");
        }
        return val;
    }

    public static int requireNonZero(int val) throws IllegalArgumentException {
        if (val == 0) {
            throw new IllegalArgumentException(val + " is zero.");
        }
        return val;
    }

    public static int requireEquals(int val, int otherVal) throws IllegalArgumentException {
        if (val != otherVal) {
            throw new IllegalArgumentException(val + " is not equal to " + otherVal);
        }
        return val;
    }

    public static int requireNotEquals(int val, int otherVal) throws IllegalArgumentException {
        if (val == otherVal) {
            throw new IllegalArgumentException(val + " is equal to." + otherVal);
        }
        return val;
    }

    public static int requireInRange(@Range int val, int from, int toExclusive) throws IllegalArgumentException {
        if (val < from || val >= toExclusive) {
            throw new IllegalArgumentException(val + " is not in the range [" + from + ", " + toExclusive + ")");
        }
        return val;
    }

    public static int requireInRangeClosed(@Range int val, int from, int toInclusive) throws IllegalArgumentException {
        if (val < from || val > toInclusive) {
            throw new IllegalArgumentException(val + " is not in the range [" + from + ", " + toInclusive + "]");
        }
        return val;
    }
}

