/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.lang.ref.Reference;
import java.util.Collection;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import org.jetbrains.annotations.Nullable;

public interface Closeable
extends java.io.Closeable,
QueryCloseable {
    public static void closeQuietly(Object ... closeables) {
        if (closeables == null) {
            return;
        }
        Closeable.closeQuietly((Object)closeables);
    }

    public static void closeQuietly(@Nullable Object o) {
        if (o instanceof Collection) {
            ((Collection)o).forEach(Closeable::closeQuietly);
        } else if (o instanceof Object[]) {
            for (Object o2 : (Object[])o) {
                Closeable.closeQuietly(o2);
            }
        } else if (o instanceof java.io.Closeable) {
            try {
                ((java.io.Closeable)o).close();
            }
            catch (Exception e) {
                Jvm.debug().on(Closeable.class, e);
            }
            catch (Throwable e) {
                Jvm.warn().on(Closeable.class, e);
            }
        } else if (o instanceof Reference) {
            Closeable.closeQuietly(((Reference)o).get());
        }
    }

    @Override
    public void close();

    @Deprecated
    default public void notifyClosing() {
    }

    default public void warnAndCloseIfNotClosed() {
        if (!this.isClosing()) {
            if (Jvm.isResourceTracing() && !AbstractCloseable.DISABLE_DISCARD_WARNING) {
                ExceptionHandler warn = Jvm.getBoolean("warnAndCloseIfNotClosed") ? Jvm.warn() : Slf4jExceptionHandler.WARN;
                warn.on(this.getClass(), "Discarded without closing " + this.toString());
            }
            Closeable.closeQuietly((Object)this);
        }
    }
}

