/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;

public class DualReferenceCounted
implements MonitorReferenceCounted {
    private final ReferenceCountedTracer a;
    private final ReferenceCountedTracer b;
    private volatile int refCount;
    private volatile AssertionError error;

    public DualReferenceCounted(ReferenceCountedTracer a, ReferenceCountedTracer b) {
        this.a = a;
        this.b = b;
        this.refCount = a.refCount();
    }

    @Override
    public void warnAndReleaseIfNotReleased() throws ClosedIllegalStateException {
        this.a.warnAndReleaseIfNotReleased();
    }

    @Override
    public void throwExceptionIfNotReleased() throws IllegalStateException {
        this.a.throwExceptionIfNotReleased();
    }

    @Override
    public StackTrace createdHere() {
        return this.a.createdHere();
    }

    @Override
    public boolean reservedBy(ReferenceOwner owner) throws IllegalStateException {
        return this.a.reservedBy(owner);
    }

    @Override
    public synchronized void reserve(ReferenceOwner id) throws IllegalStateException {
        this.checkError();
        this.a.reserve(id);
        this.b.reserve(id);
        this.refCount = this.a.refCount();
        int bRefCount = this.b.refCount();
        if (this.refCount != bRefCount) {
            this.error = new AssertionError((Object)(this.refCount + " != " + bRefCount + " , id= " + id));
            throw this.error;
        }
    }

    private void checkError() {
        if (this.error != null) {
            throw new AssertionError("Unable to use this resource due to previous error", (Throwable)((Object)this.error));
        }
    }

    @Override
    public synchronized boolean tryReserve(ReferenceOwner id) throws IllegalStateException, IllegalArgumentException {
        this.checkError();
        boolean aa = this.a.tryReserve(id);
        boolean bb = this.b.tryReserve(id);
        assert (aa == bb);
        this.refCount = this.a.refCount();
        if (this.refCount != this.b.refCount()) {
            this.error = new AssertionError(this.refCount + " != " + this.b.refCount() + " , id= " + id, (Throwable)((Object)this.error));
            throw this.error;
        }
        return aa;
    }

    @Override
    public synchronized void release(ReferenceOwner id) throws IllegalStateException {
        this.checkError();
        this.a.release(id);
        this.b.release(id);
        this.refCount = this.a.refCount();
        int refCountB = this.b.refCount();
        if (this.refCount != refCountB) {
            this.error = new AssertionError(this.refCount + " != " + refCountB + " , id= " + id, (Throwable)((Object)this.error));
            throw this.error;
        }
    }

    @Override
    public synchronized void releaseLast(ReferenceOwner id) throws IllegalStateException {
        this.checkError();
        this.a.releaseLast(id);
        this.b.releaseLast(id);
        this.refCount = this.a.refCount();
        if (this.refCount != this.b.refCount()) {
            this.error = new AssertionError(this.refCount + " != " + this.b.refCount() + " , id= " + id, (Throwable)((Object)this.error));
            throw this.error;
        }
    }

    @Override
    public int refCount() {
        return this.refCount;
    }

    @Override
    public void throwExceptionIfReleased() throws ClosedIllegalStateException {
        this.checkError();
        this.a.throwExceptionIfReleased();
    }

    @Override
    public synchronized void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.checkError();
        this.a.reserveTransfer(from, to);
        this.b.reserveTransfer(from, to);
        this.refCount = this.a.refCount();
        if (this.refCount != this.b.refCount()) {
            this.error = new AssertionError((Object)(this.refCount + " != " + this.b.refCount() + " , from= " + from + ", to=" + to));
            throw this.error;
        }
    }

    @Override
    public int referenceId() {
        return this.a.referenceId();
    }

    @Override
    public String referenceName() {
        return this.a.referenceName();
    }
}

