/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.time.Differencer;

public class RunningMinimum
implements Differencer {
    private final long actualMinimum;
    private final int drift;
    private long lastStartTime = Long.MIN_VALUE;
    private long minimum = Long.MAX_VALUE;

    public RunningMinimum(long actualMinimum) {
        this(actualMinimum, 100000);
    }

    private RunningMinimum(long actualMinimum, int drift) {
        this.actualMinimum = actualMinimum;
        this.drift = drift;
    }

    @Override
    public long sample(long startTime, long endTime) {
        long delta;
        if (this.lastStartTime + (long)this.drift <= startTime) {
            if (this.lastStartTime != Long.MIN_VALUE) {
                this.minimum += (startTime - this.lastStartTime) / (long)this.drift;
            }
            this.lastStartTime = startTime;
        }
        if (this.minimum > (delta = endTime - startTime)) {
            this.minimum = delta;
        }
        return delta - this.minimum + this.actualMinimum;
    }

    public long minimum() {
        return this.minimum;
    }
}

