/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.openhft.chronicle.core.pool.EnumCache;
import net.openhft.chronicle.core.util.CoreDynamicEnum;

public class DynamicEnumSet<E extends CoreDynamicEnum<E>>
extends AbstractSet<E>
implements Cloneable {
    final EnumCache<E> universe;
    private long[] elementsArr;
    private boolean allOf;
    private int size = 0;
    private int length = 0;

    protected DynamicEnumSet(Class<E> eClass) {
        this.universe = EnumCache.of(eClass);
        this.elementsArr = new long[this.universe.size() + 63 >>> 6];
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> noneOf(Class<E> universe) {
        return new DynamicEnumSet<E>(universe);
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> allOf(Class<E> universe) {
        DynamicEnumSet<E> result = DynamicEnumSet.noneOf(universe);
        result.allOf = true;
        return result;
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> copyOf(DynamicEnumSet<E> s) {
        return s.clone();
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> copyOf(Collection<E> c) {
        if (c instanceof DynamicEnumSet) {
            return ((DynamicEnumSet)c).clone();
        }
        if (c.isEmpty()) {
            throw new IllegalArgumentException("Collection is empty");
        }
        Iterator<E> i = c.iterator();
        CoreDynamicEnum first = (CoreDynamicEnum)i.next();
        DynamicEnumSet<CoreDynamicEnum> result = DynamicEnumSet.of(first);
        while (i.hasNext()) {
            result.add((CoreDynamicEnum)i.next());
        }
        return result;
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> complementOf(DynamicEnumSet<E> s) {
        DynamicEnumSet<E> result = DynamicEnumSet.copyOf(s);
        result.complement();
        return result;
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> of(E e) {
        DynamicEnumSet<?> result = DynamicEnumSet.noneOf(e.getClass());
        result.add(e);
        return result;
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> of(E e1, E e2) {
        DynamicEnumSet<?> result = DynamicEnumSet.noneOf(e1.getClass());
        result.add(e1);
        result.add(e2);
        return result;
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> of(E e1, E e2, E e3) {
        DynamicEnumSet<?> result = DynamicEnumSet.noneOf(e1.getClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        return result;
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> of(E e1, E e2, E e3, E e4) {
        DynamicEnumSet<?> result = DynamicEnumSet.noneOf(e1.getClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        result.add(e4);
        return result;
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        DynamicEnumSet<?> result = DynamicEnumSet.noneOf(e1.getClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        result.add(e4);
        result.add(e5);
        return result;
    }

    @SafeVarargs
    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> of(E first, E ... rest) {
        DynamicEnumSet<?> result = DynamicEnumSet.noneOf(first.getClass());
        result.add(first);
        for (E e : rest) {
            result.add(e);
        }
        return result;
    }

    public static <E extends CoreDynamicEnum<E>> DynamicEnumSet<E> range(E from, E to) {
        if (from.ordinal() > to.ordinal()) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        DynamicEnumSet<?> result = DynamicEnumSet.noneOf(from.getClass());
        result.addRange(from, to);
        return result;
    }

    public DynamicEnumSet<E> clone() {
        try {
            DynamicEnumSet clone = (DynamicEnumSet)super.clone();
            clone.elementsArr = (long[])this.elementsArr.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    final void typeCheck(E e) {
        Class<?> type;
        Class<?> eClass = e.getClass();
        if (eClass != (type = this.universe.type()) && eClass.getSuperclass() != type) {
            throw new ClassCastException(eClass + " != " + type);
        }
    }

    void addRange(E from, E to) {
        int fromOordinal = from.ordinal();
        int toOrdinal = to.ordinal();
        this.addRange(fromOordinal, toOrdinal);
    }

    void addRange(int fromOordinal, int toOrdinal) {
        int fromIndex = fromOordinal >>> 6;
        int toIndex = toOrdinal >>> 6;
        if (fromIndex == toIndex) {
            this.elementsOr(fromIndex, -1L >>> fromOordinal - toOrdinal - 1 << fromOordinal);
        } else {
            this.elementsOr(fromIndex, -1L << fromOordinal);
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                this.elementsOr(i, -1L);
            }
            this.elementsOr(toIndex, -1L >>> 63 - toOrdinal);
        }
        this.size += toOrdinal - fromOordinal + 1;
    }

    void complement() {
        for (int i = 0; i < this.elementsArr.length; ++i) {
            this.elements(i, this.elements(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (this.elementsArr.length > 0) {
            this.elementsAnd(this.elementsArr.length - 1, -1L >>> -this.length);
        }
        this.size = this.universe.size() - this.size();
        this.allOf = !this.allOf;
    }

    @Override
    public Iterator<E> iterator() {
        return new DynamicEnumSetIterator();
    }

    @Override
    public int size() {
        return (this.allOf ? this.universe.size() - this.length : 0) + this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object e) {
        Class<?> type;
        if (e == null) {
            return false;
        }
        Class<?> eClass = e.getClass();
        if (eClass != (type = this.universe.type()) && eClass.getSuperclass() != type) {
            return false;
        }
        int eOrdinal = ((Enum)e).ordinal();
        return this.containsByOrdinal(eOrdinal);
    }

    protected boolean containsByOrdinal(int eOrdinal) {
        if (eOrdinal >= this.length) {
            return this.allOf;
        }
        return (this.elements(eOrdinal >>> 6) & 1L << eOrdinal) != 0L;
    }

    @Override
    public boolean add(E e) {
        boolean result;
        this.typeCheck(e);
        int eOrdinal = e.ordinal();
        this.ensureLength(eOrdinal + 1);
        int eWordNum = eOrdinal >>> 6;
        long oldElements = this.elements(eWordNum);
        this.elementsOr(eWordNum, 1L << eOrdinal);
        boolean bl = result = this.elements(eWordNum) != oldElements;
        if (result) {
            ++this.size;
        }
        return result;
    }

    private void ensureLength(int i) {
        if (i > this.length) {
            this.ensureCapacity(i >>> 6);
            if (this.allOf) {
                this.addRange(this.length, i);
            }
            this.length = i;
        }
    }

    @Override
    public boolean remove(Object e) {
        Class<?> type;
        if (e == null) {
            return false;
        }
        Class<?> eClass = e.getClass();
        if (eClass != (type = this.universe.type()) && eClass.getSuperclass() != type) {
            return false;
        }
        int eOrdinal = ((Enum)e).ordinal();
        return this.removeByOrdinal(eOrdinal);
    }

    protected boolean removeByOrdinal(int eOrdinal) {
        boolean result;
        int eWordNum = eOrdinal >>> 6;
        if (this.length <= eOrdinal && this.allOf) {
            if (eWordNum >= this.elementsArr.length) {
                this.elementsArr = Arrays.copyOf(this.elementsArr, eWordNum);
            }
            this.addRange(this.length, eOrdinal);
            this.length = eOrdinal + 1;
        }
        long oldElements = this.elements(eWordNum);
        this.elementsAnd(eWordNum, 1L << eOrdinal ^ 0xFFFFFFFFFFFFFFFFL);
        boolean bl = result = this.elements(eWordNum) != oldElements;
        if (result) {
            --this.size;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (!(c instanceof DynamicEnumSet)) {
            return super.containsAll(c);
        }
        DynamicEnumSet es = (DynamicEnumSet)c;
        if (es.universe != this.universe) {
            return es.isEmpty();
        }
        this.equalizeLength(es);
        for (int i = 0; i < this.elementsArr.length; ++i) {
            if ((es.elements(i) & (this.elements(i) ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (!(c instanceof DynamicEnumSet)) {
            return super.addAll(c);
        }
        DynamicEnumSet es = (DynamicEnumSet)c;
        if (es.universe != this.universe) {
            if (es.isEmpty()) {
                return false;
            }
            throw new ClassCastException(es.universe + " != " + this.universe);
        }
        this.equalizeLength(es);
        for (int i = 0; i < this.elementsArr.length; ++i) {
            this.elementsOr(i, es.elements(i));
        }
        return this.recalculateSize();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!(c instanceof DynamicEnumSet)) {
            return super.removeAll(c);
        }
        DynamicEnumSet es = (DynamicEnumSet)c;
        if (es.universe != this.universe) {
            return false;
        }
        this.equalizeLength(es);
        for (int i = 0; i < this.elementsArr.length; ++i) {
            this.elementsAnd(i, es.elements(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return this.recalculateSize();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!(c instanceof DynamicEnumSet)) {
            return super.retainAll(c);
        }
        DynamicEnumSet es = (DynamicEnumSet)c;
        if (es.universe != this.universe) {
            boolean changed = this.size != 0;
            this.clear();
            return changed;
        }
        this.equalizeLength(es);
        for (int i = 0; i < this.elementsArr.length; ++i) {
            this.elementsAnd(i, es.elements(i));
        }
        return this.recalculateSize();
    }

    long elements(int i) {
        return this.elementsArr[i];
    }

    void elements(int i, long v) {
        this.ensureCapacity(i);
        this.elementsArr[i] = v;
    }

    void elementsAnd(int i, long v) {
        if (i >= this.elementsArr.length) {
            return;
        }
        int n = i;
        this.elementsArr[n] = this.elementsArr[n] & v;
    }

    void elementsOr(int i, long v) {
        this.ensureCapacity(i);
        int n = i;
        this.elementsArr[n] = this.elementsArr[n] | v;
    }

    private void ensureCapacity(int i) {
        if (i >= this.elementsArr.length) {
            this.elementsArr = Arrays.copyOf(this.elementsArr, i + 1);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.elementsArr, 0L);
        this.size = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DynamicEnumSet)) {
            return super.equals(o);
        }
        DynamicEnumSet es = (DynamicEnumSet)o;
        if (es.universe != this.universe) {
            return this.size == 0 && es.size == 0;
        }
        this.equalizeLength(es);
        return Arrays.equals(es.elementsArr, this.elementsArr);
    }

    protected void equalizeLength(DynamicEnumSet<?> es) {
        this.ensureLength(es.length);
        super.ensureLength(this.length);
    }

    private boolean recalculateSize() {
        if (this.elementsArr.length > 0) {
            this.elementsAnd(this.elementsArr.length - 1, -1L >>> -this.length);
        }
        int oldSize = this.size;
        this.size = 0;
        for (long elt : this.elementsArr) {
            this.size += Long.bitCount(elt);
        }
        return this.size != oldSize;
    }

    class DynamicEnumSetIterator
    implements Iterator<E> {
        int nextIndex = -1;
        int lastIndex = -1;

        public DynamicEnumSetIterator() {
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastIndex = this.nextIndex;
            this.findNext();
            return (CoreDynamicEnum)DynamicEnumSet.this.universe.forIndex(this.lastIndex);
        }

        private void findNext() {
            assert (this.nextIndex != Integer.MIN_VALUE);
            int size = DynamicEnumSet.this.universe.size();
            while (++this.nextIndex < size) {
                if (!DynamicEnumSet.this.containsByOrdinal(this.nextIndex)) continue;
                return;
            }
            this.nextIndex = Integer.MIN_VALUE;
        }

        @Override
        public void remove() {
            if (this.lastIndex < 0) {
                throw new IllegalStateException();
            }
            DynamicEnumSet.this.removeByOrdinal(this.lastIndex);
        }
    }
}

