/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.DynamicEnumPooled;
import net.openhft.chronicle.core.pool.EnumCache;

public class DynamicEnumClass<E extends DynamicEnumPooled>
extends EnumCache<E> {
    final Map<String, E> eMap = Collections.synchronizedMap(new LinkedHashMap());
    private final Field nameField;
    private final Field ordinalField;
    private final Function<String, E> create = this::create;

    DynamicEnumClass(Class<E> eClass) {
        super(eClass);
        DynamicEnumPooled[] enumConstants;
        for (DynamicEnumPooled e : enumConstants = eClass.isEnum() ? (DynamicEnumPooled[])eClass.getEnumConstants() : this.getStaticConstants(eClass)) {
            this.eMap.put(e.name(), e);
        }
        this.nameField = Jvm.getField(eClass, "name");
        this.ordinalField = Enum.class.isAssignableFrom(eClass) ? Jvm.getField(eClass, "ordinal") : null;
    }

    private E[] getStaticConstants(Class<E> eClass) {
        Field[] fields;
        ArrayList<DynamicEnumPooled> eList = new ArrayList<DynamicEnumPooled>();
        for (Field field : fields = eClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || field.getType() != eClass) continue;
            try {
                field.setAccessible(true);
                Object o = field.get(null);
                eList.add((DynamicEnumPooled)o);
            }
            catch (IllegalAccessException e) {
                Jvm.warn().on(this.getClass(), e.toString());
            }
        }
        return eList.toArray(new DynamicEnumPooled[eList.size()]);
    }

    @Override
    public E get(String name) {
        return (E)((DynamicEnumPooled)this.eMap.get(name));
    }

    @Override
    public E valueOf(String name) {
        return (E)((DynamicEnumPooled)this.eMap.computeIfAbsent(name, this.create));
    }

    private E create(String name) {
        try {
            DynamicEnumPooled e = (DynamicEnumPooled)OS.memory().allocateInstance(this.eClass);
            this.nameField.set(e, name);
            if (this.ordinalField != null) {
                this.ordinalField.set(e, this.eMap.size());
            }
            return (E)e;
        }
        catch (Exception e1) {
            throw new AssertionError((Object)e1);
        }
    }

    @Override
    public int initialSize() {
        return Maths.nextPower2(this.eMap.size(), 64);
    }
}

