/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.util.Scanner;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.TimeLimitExceededException;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.jetbrains.annotations.NotNull;
import sun.nio.ch.FileChannelImpl;

public final class OS
extends Enum<OS> {
    public static final String TMP;
    public static final String USER_DIR;
    public static final String USER_HOME;
    static final ClassLocal<MethodHandle> MAP0_MH;
    private static final String HOST_NAME;
    private static final String USER_NAME;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private static final boolean IS64BIT;
    private static final AtomicInteger PROCESS_ID;
    private static final String OS;
    private static final boolean IS_LINUX;
    private static final boolean IS_MAC;
    private static final boolean IS_WIN;
    private static final boolean IS_WIN10;
    private static final AtomicLong memoryMapped;
    private static final MethodHandle UNMAPP0_MH;
    private static final MethodHandle READ0_MH;
    private static final MethodHandle WRITE0_MH;
    private static final MethodHandle WRITE0_MH2;
    public static final Exception TIME_LIMIT;
    @Deprecated
    public static final String TARGET;
    private static int PAGE_SIZE;
    private static int MAP_ALIGNMENT;
    private static final /* synthetic */ OS[] $VALUES;

    public static OS[] values() {
        return (OS[])$VALUES.clone();
    }

    public static OS valueOf(String name) {
        return Enum.valueOf(OS.class, name);
    }

    @NotNull
    private static String findTarget() {
        String target = System.getProperty("project.build.directory");
        if (target != null) {
            return target;
        }
        for (File dir = new File(System.getProperty("user.dir")); dir != null; dir = dir.getParentFile()) {
            File mavenTarget = new File(dir, "target");
            if (mavenTarget.exists()) {
                return mavenTarget.getAbsolutePath();
            }
            File gradleTarget = new File(dir, "build");
            if (!gradleTarget.exists()) continue;
            return gradleTarget.getAbsolutePath();
        }
        return TMP + "/target";
    }

    @NotNull
    public static String findDir(@NotNull String suffix) throws FileNotFoundException {
        for (String s : System.getProperty("java.class.path").split(":")) {
            if (!s.endsWith(suffix) || !new File(s).isDirectory()) continue;
            return s;
        }
        throw new FileNotFoundException(suffix);
    }

    @NotNull
    public static File findFile(String ... path) {
        File dir = new File(".").getAbsoluteFile();
        for (int i = 0; i < path.length - 1; ++i) {
            File dir2 = new File(dir, path[i]);
            if (!dir2.isDirectory()) continue;
            dir = dir2;
        }
        return new File(dir, path[path.length - 1]);
    }

    public static String getHostName() {
        return HOST_NAME;
    }

    public static String getUserName() {
        return USER_NAME;
    }

    public static String getTarget() {
        return TARGET;
    }

    private static String getHostName0() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    @NotNull
    public static Memory memory() {
        return UnsafeMemory.INSTANCE;
    }

    public static long pageAlign(long size) {
        long mask = net.openhft.chronicle.core.OS.pageSize() - 1;
        return size + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int pageSize() {
        if (PAGE_SIZE == 0) {
            PAGE_SIZE = net.openhft.chronicle.core.OS.memory().pageSize();
        }
        return PAGE_SIZE;
    }

    public static long mapAlign(long offset) {
        int chunkMultiple = (int)net.openhft.chronicle.core.OS.mapAlignment();
        return (offset + (long)chunkMultiple - 1L) / (long)chunkMultiple * (long)chunkMultiple;
    }

    public static long mapAlignment() {
        if (MAP_ALIGNMENT == 0) {
            MAP_ALIGNMENT = net.openhft.chronicle.core.OS.isWindows() ? 65536 : net.openhft.chronicle.core.OS.pageSize();
        }
        return MAP_ALIGNMENT;
    }

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int getProcessId() {
        int id = PROCESS_ID.get();
        if (id == 0) {
            id = net.openhft.chronicle.core.OS.getProcessId0();
            PROCESS_ID.set(id);
        }
        return id;
    }

    private static int getProcessId0() {
        String pid = null;
        File self = new File("/proc/self");
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid != null) {
            try {
                return Integer.parseInt(pid);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int rpid = ThreadLocalRandom.current().nextInt(2, 65536);
        Jvm.warn().on(OS.class, "Unable to determine PID, picked a random number=" + rpid);
        return rpid;
    }

    public static boolean isWindows() {
        return IS_WIN;
    }

    public static boolean isMacOSX() {
        return IS_MAC;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static long getPidMax() throws NumberFormatException {
        if (net.openhft.chronicle.core.OS.isLinux()) {
            File file = new File("/proc/sys/kernel/pid_max");
            if (file.canRead()) {
                try {
                    return Maths.nextPower2(new Scanner(file).nextLong(), 1L);
                }
                catch (FileNotFoundException e) {
                    Jvm.debug().on(OS.class, e);
                }
                catch (IllegalArgumentException e) {
                    throw new AssertionError((Object)e);
                }
            }
        } else if (net.openhft.chronicle.core.OS.isMacOSX()) {
            return 0x1000000L;
        }
        return IS_WIN10 ? 0x100000000L : 65536L;
    }

    public static long map(@NotNull FileChannel fileChannel, FileChannel.MapMode mode, long start, long size) throws IOException, IllegalArgumentException {
        if (net.openhft.chronicle.core.OS.isWindows() && size > 0x100000000L) {
            throw new IllegalArgumentException("Mapping more than 4096 MiB is unusable on Windows, size = " + (size >> 20) + " MiB");
        }
        return net.openhft.chronicle.core.OS.map0(fileChannel, net.openhft.chronicle.core.OS.imodeFor(mode), net.openhft.chronicle.core.OS.mapAlign(start), net.openhft.chronicle.core.OS.pageAlign(size));
    }

    private static long invokeFileChannelMap0(@NotNull MethodHandle map0, @NotNull FileChannel fileChannel, int imode, long start, long size, @NotNull ThrowingFunction<OutOfMemoryError, Long, IOException> errorHandler) throws IOException {
        try {
            if (Jvm.isJava14Plus()) {
                return map0.invokeExact((FileChannelImpl)fileChannel, imode, start, size, false);
            }
            return map0.invokeExact((FileChannelImpl)fileChannel, imode, start, size);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Method map0 is not accessible", e);
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                return errorHandler.apply((OutOfMemoryError)e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    static long map0(@NotNull FileChannel fileChannel, int imode, long start, long size) throws IOException {
        MethodHandle map0 = (MethodHandle)MAP0_MH.get(fileChannel.getClass());
        long address = net.openhft.chronicle.core.OS.invokeFileChannelMap0(map0, fileChannel, imode, start, size, oome1 -> {
            System.gc();
            Jvm.pause(100L);
            return net.openhft.chronicle.core.OS.invokeFileChannelMap0(map0, fileChannel, imode, start, size, oome2 -> {
                throw new IOException("Map failed", (Throwable)oome2);
            });
        });
        memoryMapped.addAndGet(size);
        return address;
    }

    public static void unmap(long address, long size) throws IOException {
        try {
            long size2 = net.openhft.chronicle.core.OS.pageAlign(size);
            int n = UNMAPP0_MH.invokeExact(address, size2);
            memoryMapped.addAndGet(-size2);
        }
        catch (Throwable e) {
            throw net.openhft.chronicle.core.OS.asAnIOException(e);
        }
    }

    public static long memoryMapped() {
        return memoryMapped.get();
    }

    @NotNull
    private static IOException asAnIOException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    static int imodeFor(FileChannel.MapMode mode) {
        int imode = -1;
        if (FileChannel.MapMode.READ_ONLY.equals(mode)) {
            imode = 0;
        } else if (FileChannel.MapMode.READ_WRITE.equals(mode)) {
            imode = 1;
        } else if (FileChannel.MapMode.PRIVATE.equals(mode)) {
            imode = 2;
        }
        assert (imode >= 0);
        return imode;
    }

    public static long spaceUsed(@NotNull String filename) {
        return net.openhft.chronicle.core.OS.spaceUsed(new File(filename));
    }

    private static long spaceUsed(@NotNull File file) {
        if (!net.openhft.chronicle.core.OS.isWindows()) {
            try {
                String du_k = net.openhft.chronicle.core.OS.run("du", "-ks", file.getAbsolutePath());
                return Long.parseLong(du_k.substring(0, du_k.indexOf(9)));
            }
            catch (IOException | NumberFormatException e) {
                Jvm.warn().on(OS.class, e);
            }
        }
        return file.length();
    }

    private static String run(String ... cmds) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmds);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        StringWriter sw = new StringWriter();
        char[] chars = new char[1024];
        try (InputStreamReader r = new InputStreamReader(process.getInputStream());){
            int len;
            while ((len = r.read(chars)) > 0) {
                sw.write(chars, 0, len);
            }
        }
        return sw.toString();
    }

    public static String userDir() {
        return USER_DIR;
    }

    public static int read0(FileDescriptor fd, long address, int len) throws IOException {
        try {
            return READ0_MH.invokeExact(fd, address, len);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static int write0(FileDescriptor fd, long address, int len) throws IOException {
        try {
            if (WRITE0_MH2 == null) {
                return WRITE0_MH.invokeExact(fd, address, len);
            }
            return WRITE0_MH2.invokeExact(fd, address, len, false);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    static {
        $VALUES = new OS[0];
        TMP = System.getProperty("java.io.tmpdir");
        USER_DIR = System.getProperty("user.dir");
        USER_HOME = System.getProperty("user.home");
        MAP0_MH = ClassLocal.withInitial(c -> {
            try {
                Method map0 = Jvm.isJava14Plus() ? Jvm.getMethod(c, "map0", Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE) : Jvm.getMethod(c, "map0", Integer.TYPE, Long.TYPE, Long.TYPE);
                return MethodHandles.lookup().unreflect(map0);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        });
        HOST_NAME = net.openhft.chronicle.core.OS.getHostName0();
        USER_NAME = System.getProperty("user.name");
        IS64BIT = net.openhft.chronicle.core.OS.is64Bit0();
        PROCESS_ID = new AtomicInteger();
        OS = System.getProperty("os.name").toLowerCase();
        IS_LINUX = OS.startsWith("linux");
        IS_MAC = OS.contains("mac");
        IS_WIN = OS.startsWith("win");
        IS_WIN10 = OS.equals("windows 10");
        memoryMapped = new AtomicLong();
        TIME_LIMIT = new TimeLimitExceededException();
        TARGET = net.openhft.chronicle.core.OS.findTarget();
        Jvm.debug();
        try {
            Method unmap0 = Jvm.getMethod(FileChannelImpl.class, "unmap0", Long.TYPE, Long.TYPE);
            UNMAPP0_MH = MethodHandles.lookup().unreflect(unmap0);
            Class<?> fdi = Class.forName("sun.nio.ch.FileDispatcherImpl");
            Method read0 = Jvm.getMethod(fdi, "read0", FileDescriptor.class, Long.TYPE, Integer.TYPE);
            READ0_MH = MethodHandles.lookup().unreflect(read0);
            MethodHandle write0Mh = null;
            MethodHandle write0Mh2 = null;
            try {
                Method write0 = Jvm.getMethod(fdi, "write0", FileDescriptor.class, Long.TYPE, Integer.TYPE);
                write0Mh = MethodHandles.lookup().unreflect(write0);
            }
            catch (AssertionError ae) {
                Method write0 = Jvm.getMethod(fdi, "write0", FileDescriptor.class, Long.TYPE, Integer.TYPE, Boolean.TYPE);
                write0Mh2 = MethodHandles.lookup().unreflect(write0);
            }
            WRITE0_MH = write0Mh;
            WRITE0_MH2 = write0Mh2;
            TIME_LIMIT.setStackTrace(new StackTraceElement[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final class Unmapper
    implements Runnable {
        private final long size;
        private volatile long address;

        public Unmapper(long address, long size) throws IllegalStateException {
            assert (address != 0L);
            this.address = address;
            this.size = size;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            try {
                net.openhft.chronicle.core.OS.unmap(this.address, this.size);
                this.address = 0L;
            }
            catch (IOException e) {
                Jvm.warn().on(OS.class, "Error on unmap and release", e);
            }
        }
    }
}

