/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.lang.ref.WeakReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;

public class CleaningThread
extends Thread {
    public CleaningThread(Runnable target) {
        super(target);
    }

    public CleaningThread(Runnable target, String name) {
        super(target, name);
    }

    public static void performCleanup(Thread thread) {
        WeakReference[] table = (WeakReference[])Jvm.getValue(thread, "threadLocals/table");
        if (table != null) {
            for (WeakReference reference : table) {
                Object value;
                Object key;
                Object v0 = key = reference != null ? reference.get() : null;
                if (!(key instanceof CleaningThreadLocal) || (value = Jvm.getValue(reference, "value")) == null) continue;
                CleaningThreadLocal ctl = key;
                ctl.cleanup(value);
            }
        }
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            CleaningThread.performCleanup(this);
        }
    }
}

