/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.CloseableTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;

public abstract class AbstractCloseableReferenceCounted
extends AbstractReferenceCounted
implements CloseableTracer {
    private volatile transient boolean closed;
    private volatile transient StackTrace closedHere;
    private boolean initReleased;

    public AbstractCloseableReferenceCounted() {
        Set<CloseableTracer> set = AbstractCloseable.CLOSEABLE_SET;
        if (set != null) {
            set.add(this);
        }
    }

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        this.throwExceptionIfClosed();
        super.reserve(id);
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.throwExceptionIfClosed();
        super.reserveTransfer(from, to);
        if (from == INIT) {
            this.initReleased = true;
        }
        if (to == INIT) {
            this.initReleased = false;
        }
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        super.release(id);
        if (id == INIT) {
            this.initReleased = true;
        }
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        super.releaseLast(id);
        if (id == INIT) {
            this.initReleased = true;
        }
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws IllegalStateException {
        return !this.closed && super.tryReserve(id);
    }

    @Override
    public void close() {
        if (!this.initReleased) {
            this.release(INIT);
        }
        this.setClosed();
    }

    protected void setClosed() {
        this.closed = true;
        this.closedHere = Jvm.isResourceTracing() ? new StackTrace("Closed here") : null;
    }

    @Override
    public void throwExceptionIfClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Closed", this.closedHere);
        }
        this.throwExceptionIfReleased();
        assert (this.threadSafetyCheck());
    }

    @Override
    public boolean isClosed() {
        return this.refCount() <= 0 || this.closed;
    }
}

