/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;
import org.jetbrains.annotations.NotNull;

public class ThreadDump {
    static final Map<Thread, StackTrace> THREAD_STACK_TRACE_MAP = Collections.synchronizedMap(new WeakIdentityHashMap());
    @NotNull
    final Set<Thread> threads;
    final Set<String> ignored = new HashSet<String>();

    public ThreadDump() {
        this.threads = new HashSet<Thread>(Thread.getAllStackTraces().keySet());
        this.ignored.add("Time-limited test");
        this.ignored.add("Attach Listener");
        this.ignored.add("process reaper");
        this.ignored.add("chronicle-weak-reference-cleaner");
        this.ignored.add("background-resource-releaser");
        int max = Runtime.getRuntime().availableProcessors();
        for (int i = 0; i < max; ++i) {
            this.ignored.add("ForkJoinPool.commonPool-worker-" + i);
        }
    }

    public static void add(Thread t, StackTrace stackTrace) {
        if (Jvm.isResourceTracing()) {
            THREAD_STACK_TRACE_MAP.put(t, stackTrace);
        }
    }

    public void ignore(String threadName) {
        this.ignored.add(threadName);
    }

    public void assertNoNewThreads() {
        this.assertNoNewThreads(0, TimeUnit.NANOSECONDS);
    }

    public static StackTrace createdHereFor(Thread thread) {
        return THREAD_STACK_TRACE_MAP.get(thread);
    }

    public void assertNoNewThreads(int delay, @NotNull TimeUnit delayUnit) {
        long start = System.nanoTime();
        long delayNanos = delayUnit.toNanos(delay);
        Map<Thread, StackTraceElement[]> allStackTraces = null;
        AssertionError ae = null;
        int last = 4;
        int i = 1;
        while (i <= last) {
            Jvm.pause(i * i * 50);
            allStackTraces = Thread.getAllStackTraces();
            allStackTraces.keySet().removeAll(this.threads);
            if (allStackTraces.isEmpty()) {
                return;
            }
            allStackTraces.keySet().removeIf(next -> this.ignored.stream().anyMatch(item -> next.getName().contains((CharSequence)item)));
            if (allStackTraces.isEmpty()) {
                return;
            }
            if (i == 1 && System.nanoTime() - start < delayNanos) continue;
            if (++i == last) {
                ae = new AssertionError((Object)("Threads still running " + allStackTraces.keySet()));
            }
            for (Map.Entry<Thread, StackTraceElement[]> threadEntry : allStackTraces.entrySet()) {
                StringBuilder sb = new StringBuilder();
                Thread thread = threadEntry.getKey();
                sb.append("Thread still running ").append(thread);
                Jvm.trimStackTrace(sb, threadEntry.getValue());
                System.err.println(sb);
                if (i != last) continue;
                StackTrace stackTrace = ThreadDump.createdHereFor(thread);
                StackTrace st = new StackTrace(thread.toString(), stackTrace);
                st.setStackTrace(threadEntry.getValue());
                ((Throwable)((Object)ae)).addSuppressed(st);
            }
        }
        throw ae;
    }
}

