/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.io.QueryCloseables;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;

public abstract class AbstractReferenceCounted
implements ReferenceCounted,
ReferenceOwner,
QueryCloseable {
    private final ReferenceCounted referenceCounted;
    private final QueryCloseable queryCloseable;

    protected AbstractReferenceCounted() {
        this(QueryCloseables.NEVER_CLOSED);
    }

    protected AbstractReferenceCounted(QueryCloseable queryCloseable) {
        this.queryCloseable = queryCloseable;
        Runnable performRelease = BackgroundResourceReleaser.BG_RELEASER && this.performReleaseInBackground() ? this::backgroundPerformRelease : this::inThreadPerformRelease;
        this.referenceCounted = ReferenceCounted.onReleased(performRelease);
    }

    void backgroundPerformRelease() {
        BackgroundResourceReleaser.release(this);
    }

    void inThreadPerformRelease() {
        long start = System.nanoTime();
        this.performRelease();
        long time = System.nanoTime() - start;
        if (time >= 2000000L) {
            Jvm.warn().on(this.getClass(), "Took " + (double)(time / 100000L) / 10.0 + " ms to performRelease");
        }
    }

    protected boolean performReleaseInBackground() {
        return false;
    }

    protected abstract void performRelease();

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        this.queryCloseable.throwExceptionIfClosed();
        this.referenceCounted.reserve(id);
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.release(id);
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.releaseLast(id);
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws IllegalStateException {
        return !this.queryCloseable.isClosed() && this.referenceCounted.tryReserve(id);
    }

    @Override
    public int refCount() {
        return this.referenceCounted.refCount();
    }

    @Override
    public void throwExceptionBadResourceOwner() throws IllegalStateException {
        this.referenceCounted.throwExceptionBadResourceOwner();
    }

    @Override
    public boolean isClosed() {
        return this.queryCloseable.isClosed();
    }

    @Override
    public void throwExceptionIfClosed() throws IllegalStateException {
        this.queryCloseable.throwExceptionIfClosed();
    }
}

