/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.core.onoes.NullExceptionHandler;
import net.openhft.chronicle.core.onoes.RecordingExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.onoes.ThreadLocalisedExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Jvm {

    private static final List<String> INPUT_ARGUMENTS = ManagementFactory.getRuntimeMXBean().getInputArguments();
    private static final int COMPILE_THRESHOLD = Jvm.getCompileThreshold0(INPUT_ARGUMENTS);
    private static final boolean IS_DEBUG = INPUT_ARGUMENTS.toString().contains("jdwp") || Boolean.getBoolean("debug");
    private static final boolean IS_FLIGHT_RECORDER = (" " + ManagementFactory.getRuntimeMXBean().getInputArguments()).contains(" -XX:+FlightRecorder") || Boolean.getBoolean("jfr");
    private static final Class bitsClass;
    private static final Field reservedMemory;
    @Nullable
    private static final AtomicLong reservedMemoryAtomicLong;
    @NotNull
    private static final DirectMemoryInspector DIRECT_MEMORY_INSPECTOR;
    private static final boolean IS_64BIT;
    @NotNull
    private static final ThreadLocalisedExceptionHandler FATAL;
    @NotNull
    private static final ThreadLocalisedExceptionHandler WARN;
    @NotNull
    private static final ThreadLocalisedExceptionHandler DEBUG;
    private static final long MAX_DIRECT_MEMORY;
    private static final int JVM_JAVA_MAJOR_VERSION;
    private static final boolean IS_JAVA_9_PLUS;

    private static int getCompileThreshold0(@NotNull List<String> inputArguments) {
        for (String inputArgument : inputArguments) {
            String prefix;
            if (!inputArgument.startsWith(prefix = "-XX:CompileThreshold=")) continue;
            return Integer.parseInt(inputArgument.substring(prefix.length()));
        }
        return 10000;
    }

    public static int compileThreshold() {
        return COMPILE_THRESHOLD;
    }

    public static int majorVersion() {
        return JVM_JAVA_MAJOR_VERSION;
    }

    public static boolean isJava9Plus() {
        return IS_JAVA_9_PLUS;
    }

    private static boolean is64bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    @NotNull
    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static void trimStackTrace(@NotNull StringBuilder sb, StackTraceElement ... stes) {
        int first = Jvm.trimFirst(stes);
        int last = Jvm.trimLast(first, stes);
        for (int i = first; i <= last; ++i) {
            sb.append("\n\tat ").append(stes[i]);
        }
    }

    static int trimFirst(@NotNull StackTraceElement[] stes) {
        int first;
        for (first = 0; first < stes.length && Jvm.isInternal(stes[first].getClassName()); ++first) {
        }
        return Math.max(0, first - 2);
    }

    public static int trimLast(int first, @NotNull StackTraceElement[] stes) {
        int last;
        for (last = stes.length - 1; first < last && Jvm.isInternal(stes[last].getClassName()); --last) {
        }
        if (last < stes.length - 1) {
            ++last;
        }
        return last;
    }

    static boolean isInternal(@NotNull String className) {
        return className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("java.");
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static boolean isFlightRecorder() {
        return IS_FLIGHT_RECORDER;
    }

    public static void pause(long millis) {
        long timeNanos = millis * 1000000L;
        if ((double)timeNanos > 1.0E7) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            LockSupport.parkNanos(timeNanos);
        }
    }

    public static void busyWaitMicros(long micros) {
        Jvm.busyWaitUntil(System.nanoTime() + micros * 1000L);
    }

    public static void busyWaitUntil(long waitUntil) {
        while (waitUntil > System.nanoTime()) {
        }
    }

    public static Field getField(@NotNull Class clazz, @NotNull String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    return Jvm.getField(superclass, name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AssertionError((Object)e);
        }
    }

    public static <V> V getValue(@NotNull Object obj, @NotNull String name) {
        for (String n : name.split("/")) {
            Field f = Jvm.getField(obj.getClass(), n);
            try {
                obj = f.get(obj);
                if (obj != null) continue;
                return null;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        return (V)obj;
    }

    public static String lockWithStack(@NotNull ReentrantLock lock) {
        Thread t = (Thread)Jvm.getValue(lock, "sync/exclusiveOwnerThread");
        if (t == null) {
            return lock.toString();
        }
        StringBuilder ret = new StringBuilder();
        ret.append(lock).append(" running at");
        Jvm.trimStackTrace(ret, t.getStackTrace());
        return ret.toString();
    }

    public static long usedDirectMemory() {
        return DIRECT_MEMORY_INSPECTOR.usedDirectMemory();
    }

    public static long usedNativeMemory() {
        return UnsafeMemory.INSTANCE.nativeMemoryUsed();
    }

    public static long maxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }

    public static boolean is64bit() {
        return IS_64BIT;
    }

    public static void resetExceptionHandlers() {
        FATAL.defaultHandler(Slf4jExceptionHandler.FATAL).resetThreadLocalHandler();
        WARN.defaultHandler(Slf4jExceptionHandler.WARN).resetThreadLocalHandler();
        DEBUG.defaultHandler(Slf4jExceptionHandler.DEBUG).resetThreadLocalHandler();
    }

    public static void disableDebugHandler() {
        DEBUG.defaultHandler(null).resetThreadLocalHandler();
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions() {
        return Jvm.recordExceptions(true);
    }

    @NotNull
    public static Map<ExceptionKey, Integer> recordExceptions(boolean debug) {
        Map<ExceptionKey, Integer> map = Collections.synchronizedMap(new LinkedHashMap());
        FATAL.defaultHandler(new RecordingExceptionHandler(LogLevel.FATAL, map));
        WARN.defaultHandler(new RecordingExceptionHandler(LogLevel.WARN, map));
        DEBUG.defaultHandler(debug ? new RecordingExceptionHandler(LogLevel.DEBUG, map) : NullExceptionHandler.NOTHING);
        return map;
    }

    public static boolean hasException(@NotNull Map<ExceptionKey, Integer> exceptions) {
        return exceptions.keySet().stream().anyMatch(k -> k.throwable != null && k.level != LogLevel.DEBUG);
    }

    public static void setExceptionHandlers(@Nullable ExceptionHandler fatal, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        FATAL.defaultHandler(fatal);
        WARN.defaultHandler(warn);
        DEBUG.defaultHandler(debug);
    }

    public static void setThreadLocalExceptionHandlers(@Nullable ExceptionHandler fatal, @Nullable ExceptionHandler warn, @Nullable ExceptionHandler debug) {
        FATAL.threadLocalHandler(fatal);
        WARN.threadLocalHandler(warn);
        DEBUG.threadLocalHandler(debug);
    }

    @NotNull
    public static ExceptionHandler fatal() {
        return FATAL;
    }

    @NotNull
    public static ExceptionHandler warn() {
        return WARN;
    }

    @NotNull
    public static ExceptionHandler debug() {
        return DEBUG;
    }

    public static void dumpException(@NotNull Map<ExceptionKey, Integer> exceptions) {
        System.out.println("exceptions: " + exceptions.size());
        for (Map.Entry<ExceptionKey, Integer> entry : exceptions.entrySet()) {
            Integer value;
            ExceptionKey key = entry.getKey();
            System.err.println((Object)((Object)key.level) + " " + key.clazz.getSimpleName() + " " + key.message);
            if (key.throwable != null) {
                key.throwable.printStackTrace();
            }
            if ((value = entry.getValue()) <= 1) continue;
            System.err.println("Repeated " + value + " times");
        }
        Jvm.resetExceptionHandlers();
    }

    public static boolean isDebugEnabled(Class aClass) {
        return DEBUG.isEnabled(aClass) || Jvm.isDebug();
    }

    private static long maxDirectMemory0() {
        try {
            Class<?> clz = Class.forName("sun.misc.VM");
            Method method = clz.getDeclaredMethod("maxDirectMemory", new Class[0]);
            return (Long)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            System.err.println(Jvm.class.getName() + ": Unable to determine max direct memory");
            return 0L;
        }
    }

    private static int getMajorVersion0() {
        try {
            Method method = Runtime.class.getDeclaredMethod("version", new Class[0]);
            if (method != null) {
                Object version = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
                Class<?> clz = Class.forName("java.lang.Runtime$Version");
                return (Integer)clz.getDeclaredMethod("major", new Class[0]).invoke(version, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return Integer.parseInt(Runtime.class.getPackage().getSpecificationVersion().split("\\.")[1]);
    }

    static {
        IS_64BIT = Jvm.is64bit0();
        FATAL = new ThreadLocalisedExceptionHandler(Slf4jExceptionHandler.FATAL);
        WARN = new ThreadLocalisedExceptionHandler(Slf4jExceptionHandler.WARN);
        DEBUG = new ThreadLocalisedExceptionHandler(Slf4jExceptionHandler.DEBUG);
        MAX_DIRECT_MEMORY = Jvm.maxDirectMemory0();
        JVM_JAVA_MAJOR_VERSION = Jvm.getMajorVersion0();
        IS_JAVA_9_PLUS = JVM_JAVA_MAJOR_VERSION > 8;
        try {
            bitsClass = Class.forName("java.nio.Bits");
            reservedMemory = bitsClass.getDeclaredField("reservedMemory");
            reservedMemory.setAccessible(true);
            if (reservedMemory.getType() == AtomicLong.class) {
                reservedMemoryAtomicLong = (AtomicLong)reservedMemory.get(null);
                DIRECT_MEMORY_INSPECTOR = DirectMemoryInspector.AtomicLong;
            } else {
                reservedMemoryAtomicLong = null;
                DIRECT_MEMORY_INSPECTOR = DirectMemoryInspector.Reflect;
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static enum DirectMemoryInspector {
        Reflect{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long usedDirectMemory() {
                try {
                    Class clazz = bitsClass;
                    synchronized (clazz) {
                        return reservedMemory.getLong(null);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        ,
        AtomicLong{

            @Override
            public long usedDirectMemory() {
                return reservedMemoryAtomicLong.get();
            }
        };


        public abstract long usedDirectMemory();
    }
}

