/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.time.TimeProvider;

public class SetTimeProvider
implements TimeProvider {
    private final AtomicLong nanoTime;

    public SetTimeProvider() {
        this(0L);
    }

    public SetTimeProvider(long initialNanos) {
        this.nanoTime = new AtomicLong(initialNanos);
    }

    public void currentTimeMillis(long millis) {
        this.currentTimeNanos(TimeUnit.MILLISECONDS.toNanos(millis));
    }

    @Override
    public long currentTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanoTime.get());
    }

    public void currentTimeMicros(long micros) {
        this.currentTimeNanos(TimeUnit.MICROSECONDS.toNanos(micros));
    }

    @Override
    public long currentTimeMicros() {
        return TimeUnit.NANOSECONDS.toMicros(this.nanoTime.get());
    }

    public void currentTimeNanos(long nanos) {
        if (nanos < this.nanoTime.get()) {
            throw new IllegalArgumentException("Cannot go back in time!");
        }
        this.nanoTime.set(nanos);
    }

    @Override
    public long currentTimeNanos() {
        return this.nanoTime.get();
    }

    @Override
    public long currentTime(TimeUnit unit) {
        return unit.convert(this.nanoTime.get(), TimeUnit.NANOSECONDS);
    }

    public SetTimeProvider advanceMillis(long millis) {
        this.nanoTime.addAndGet(TimeUnit.MILLISECONDS.toNanos(millis));
        return this;
    }

    public SetTimeProvider advanceMicros(long micros) {
        this.nanoTime.addAndGet(TimeUnit.MICROSECONDS.toNanos(micros));
        return this;
    }

    public SetTimeProvider advanceNanos(long nanos) {
        this.nanoTime.addAndGet(nanos);
        return this;
    }
}

