/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.NullExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;

public class ThreadLocalisedExceptionHandler
implements ExceptionHandler {
    private ExceptionHandler defaultHandler;
    private ThreadLocal<ExceptionHandler> handlerTL;

    public ThreadLocalisedExceptionHandler(Slf4jExceptionHandler handler) {
        this.defaultHandler = handler;
        this.resetThreadLocalHandler();
    }

    @Override
    public void on(Class clazz, String message, Throwable thrown) {
        ExceptionHandler exceptionHandler = this.handlerTL.get();
        if (exceptionHandler == null) {
            exceptionHandler = this.defaultHandler;
        }
        if (exceptionHandler == null) {
            return;
        }
        exceptionHandler.on(clazz, message, thrown);
    }

    public ExceptionHandler defaultHandler() {
        return this.defaultHandler;
    }

    public ThreadLocalisedExceptionHandler defaultHandler(ExceptionHandler defaultHandler) {
        this.defaultHandler = defaultHandler == null ? NullExceptionHandler.NOTHING : defaultHandler;
        return this;
    }

    public ExceptionHandler threadLocalHandler() {
        return this.handlerTL.get();
    }

    public ThreadLocalisedExceptionHandler threadLocalHandler(ExceptionHandler handler) {
        this.handlerTL.set(handler);
        return this;
    }

    public void resetThreadLocalHandler() {
        this.handlerTL = new InheritableThreadLocal<ExceptionHandler>();
    }
}

