/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.lang.ref.WeakReference;
import java.util.function.Function;
import java.util.function.Supplier;

public enum ThreadLocalHelper {


    public static <T> T getTL(ThreadLocal<WeakReference<T>> threadLocal, Supplier<T> supplier) {
        WeakReference<Object> ref = threadLocal.get();
        Object ret = null;
        if (ref != null) {
            ret = ref.get();
        }
        if (ret == null) {
            ret = supplier.get();
            ref = new WeakReference<Object>(ret);
            threadLocal.set(ref);
        }
        return ret;
    }

    public static <T, A> T getTL(ThreadLocal<WeakReference<T>> threadLocal, A a, Function<A, T> function) {
        WeakReference<Object> ref = threadLocal.get();
        Object ret = null;
        if (ref != null) {
            ret = ref.get();
        }
        if (ret == null) {
            ret = function.apply(a);
            ref = new WeakReference<Object>(ret);
            threadLocal.set(ref);
        }
        return ret;
    }
}

