/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;
import sun.reflect.Reflection;

public enum IOTools {


    public static boolean shallowDeleteDirWithFiles(String directory) throws IORuntimeException {
        return IOTools.shallowDeleteDirWithFiles(new File(directory));
    }

    public static boolean shallowDeleteDirWithFiles(File dir) throws IORuntimeException {
        return IOTools.deleteDirWithFiles(dir, 1);
    }

    public static boolean deleteDirWithFiles(String dir, int maxDepth) throws IORuntimeException {
        return IOTools.deleteDirWithFiles(new File(dir), maxDepth);
    }

    public static boolean deleteDirWithFiles(File dir, int maxDepth) throws IORuntimeException {
        File[] entries = dir.listFiles();
        if (entries == null) {
            return false;
        }
        Stream.of(entries).filter(File::isDirectory).forEach(f -> {
            if (maxDepth < 1) {
                throw new AssertionError((Object)("Contains directory " + f));
            }
            IOTools.deleteDirWithFiles(f, maxDepth - 1);
        });
        Stream.of(entries).forEach(f -> {
            try {
                Files.delete(f.toPath());
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e) {
                Jvm.debug().on(Closeable.class, "Failed to delete " + f, e);
            }
        });
        return dir.delete();
    }

    public static byte[] readFile(String name) throws IOException {
        int len;
        ClassLoader classLoader;
        try {
            classLoader = Reflection.getCallerClass().getClassLoader();
        }
        catch (Throwable e) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        InputStream is = classLoader.getResourceAsStream(name);
        if (is == null) {
            is = classLoader.getResourceAsStream(name + ".gz");
        }
        if (is == null) {
            try {
                is = new FileInputStream(name);
            }
            catch (FileNotFoundException e) {
                try {
                    is = new GZIPInputStream(new FileInputStream(name + ".gz"));
                }
                catch (FileNotFoundException e1) {
                    throw e;
                }
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(Math.min(512, is.available()));
        byte[] bytes = new byte[1024];
        while ((len = is.read(bytes)) > 0) {
            out.write(bytes, 0, len);
        }
        return out.toByteArray();
    }

    public static void writeFile(String filename, byte[] bytes) throws IOException {
        OutputStream out = new FileOutputStream(filename);
        if (filename.endsWith(".gz")) {
            out = new GZIPOutputStream(out);
        }
        ((OutputStream)out).write(bytes);
        ((OutputStream)out).close();
    }

    public static String tempName(String filename) {
        int ext = filename.lastIndexOf(46);
        if (ext > 0 && ext > filename.length() - 5) {
            return filename.substring(0, ext) + System.nanoTime() + filename.substring(ext);
        }
        return filename + System.nanoTime();
    }

    public static void clean(ByteBuffer bb) {
        Cleaner cl;
        if (bb instanceof DirectBuffer && (cl = ((DirectBuffer)((Object)bb)).cleaner()) != null) {
            cl.clean();
        }
    }
}

