/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;

public enum Mocker {


    public static <T> T logging(Class<T> tClass, String description, PrintStream out) {
        return Mocker.intercepting(tClass, description, out::println);
    }

    public static <T> T logging(Class<T> tClass, String description, PrintWriter out) {
        return Mocker.intercepting(tClass, description, out::println);
    }

    public static <T> T logging(Class<T> tClass, String description, StringWriter out) {
        return Mocker.logging(tClass, description, new PrintWriter(out));
    }

    public static <T> T queuing(Class<T> tClass, String description, BlockingQueue<String> queue) {
        return Mocker.intercepting(tClass, description, queue::add);
    }

    public static <T> T intercepting(Class<T> tClass, final String description, final Consumer<String> consumer) {
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), new Class[]{tClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                consumer.accept(description + method.getName() + (args == null ? "()" : Arrays.toString(args)));
                return null;
            }
        });
    }

    public static <T> T ignored(Class<T> tClass) {
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), new Class[]{tClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                return null;
            }
        });
    }
}

