/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.pool.ClassLookup;

public class ClassAliasPool
implements ClassLookup {
    public static final ClassAliasPool CLASS_ALIASES = new ClassAliasPool(null).defaultAliases();
    private final ClassLookup parent;
    private final ClassLoader classLoader;
    private final Map<String, Class> stringClassMap = new ConcurrentHashMap<String, Class>();
    private final Map<String, Class> stringClassMap2 = new ConcurrentHashMap<String, Class>();
    private final Map<Class, String> classStringMap = new ConcurrentHashMap<Class, String>();

    ClassAliasPool(ClassLookup parent, ClassLoader classLoader) {
        this.parent = parent;
        this.classLoader = classLoader;
    }

    ClassAliasPool(ClassLookup parent) {
        this.parent = parent;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    private ClassAliasPool defaultAliases() {
        this.addAlias(Set.class, "!set");
        this.addAlias(SortedSet.class, "!oset");
        this.addAlias(List.class, "!seq");
        this.addAlias(Map.class, "!map");
        this.addAlias(SortedMap.class, "!omap");
        this.addAlias(String.class, "String, !str");
        this.addAlias(CharSequence.class);
        this.addAlias(Byte.class, "byte, int8");
        this.addAlias(Short.class, "short, int16");
        this.addAlias(Character.class, "Char");
        this.addAlias(Integer.class, "int, int32");
        this.addAlias(Long.class, "long, int64");
        this.addAlias(Float.class, "Float32");
        this.addAlias(Double.class, "Float64");
        this.addAlias(LocalDate.class, "Date");
        this.addAlias(LocalDateTime.class, "DateTime");
        this.addAlias(LocalTime.class, "Time");
        this.addAlias(ZonedDateTime.class, "ZonedDateTime");
        this.addAlias(String[].class, "String[]");
        for (Class prim : new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            this.addAlias(Array.newInstance(prim, 0).getClass(), prim.getName() + "[]");
        }
        this.addAlias(Class.class, "type");
        this.addAlias(Void.TYPE, "!null");
        return this;
    }

    public void clean() {
        this.clean(this.stringClassMap.values());
        this.clean(this.stringClassMap2.values());
        this.clean(this.classStringMap.keySet());
    }

    private void clean(Iterable<Class> coll) {
        ClassLoader classLoader2 = ClassAliasPool.class.getClassLoader();
        Iterator<Class> iter = coll.iterator();
        while (iter.hasNext()) {
            Class clazz = iter.next();
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null || classLoader == classLoader2) continue;
            iter.remove();
        }
    }

    @Override
    public Class forName(CharSequence name) throws ClassNotFoundException {
        String name0 = name.toString();
        Class clazz = this.stringClassMap.get(name0);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.stringClassMap2.get(name0);
        if (clazz != null) {
            return clazz;
        }
        return this.parent == null ? this.forName0(name, name0) : this.parent.forName(name);
    }

    private Class forName0(CharSequence name, String name0) {
        return this.stringClassMap2.computeIfAbsent(name0, n -> {
            try {
                return Class.forName(name0, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                if (this.parent != null) {
                    try {
                        return this.parent.forName(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                throw Jvm.rethrow(e);
            }
        });
    }

    @Override
    public String nameFor(Class clazz) {
        String name = this.classStringMap.get(clazz);
        return name == null ? (this.parent == null ? this.nameFor0(clazz) : this.parent.nameFor(clazz)) : name;
    }

    private String nameFor0(Class clazz) {
        return this.classStringMap.computeIfAbsent(clazz, aClass -> {
            Class clazz2;
            if (Enum.class.isAssignableFrom((Class<?>)aClass) && (clazz2 = aClass.getSuperclass()) != null && clazz2 != Enum.class && Enum.class.isAssignableFrom(clazz2)) {
                aClass = clazz2;
                String alias = this.classStringMap.get(clazz2);
                if (alias != null) {
                    return alias;
                }
            }
            return aClass.getName();
        });
    }

    @Override
    public void addAlias(Class ... classes) {
        for (Class clazz : classes) {
            this.stringClassMap.putIfAbsent(clazz.getName(), clazz);
            this.stringClassMap2.putIfAbsent(clazz.getSimpleName(), clazz);
            this.stringClassMap2.putIfAbsent(this.toCamelCase(clazz.getSimpleName()), clazz);
            this.classStringMap.computeIfAbsent(clazz, Class::getSimpleName);
        }
    }

    private String toCamelCase(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    @Override
    public void addAlias(Class clazz, String names) {
        for (String name : names.split(", ?")) {
            this.stringClassMap.put(name, clazz);
            this.stringClassMap2.putIfAbsent(this.toCamelCase(name), clazz);
            this.classStringMap.putIfAbsent(clazz, name);
            this.addAlias(clazz);
        }
    }
}

