/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.tcp;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.tcp.VanillaSocketChannel;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;

public class FastJ8SocketChannel
extends VanillaSocketChannel {
    final FileDescriptor fd;
    private final AtomicBoolean readLock = new AtomicBoolean();
    volatile boolean open;
    private volatile boolean blocking;

    FastJ8SocketChannel(SocketChannel socketChannel) {
        super(socketChannel);
        this.fd = (FileDescriptor)Jvm.getValue(socketChannel, "fd");
        this.open = socketChannel.isOpen();
        this.blocking = socketChannel.isBlocking();
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (this.isBlocking() || !this.isOpen() || !(buf instanceof DirectBuffer)) {
            return super.read(buf);
        }
        return this.read0(buf);
    }

    int read0(ByteBuffer buf) throws IOException {
        try {
            while (!this.readLock.compareAndSet(false, true)) {
                if (Thread.interrupted()) {
                    throw new IOException(new InterruptedException());
                }
                if (this.isOpen()) continue;
                int n = -1;
                return n;
            }
            int n = this.readInternal(buf);
            return n;
        }
        finally {
            this.readLock.compareAndSet(true, false);
        }
    }

    @Override
    public void configureBlocking(boolean blocking) throws IOException {
        super.configureBlocking(blocking);
        this.blocking = super.isBlocking();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.open = super.isOpen();
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        try {
            int write = super.write(byteBuffer);
            this.open &= write >= 0;
            return write;
        }
        catch (Exception e) {
            this.open = super.isOpen();
            throw e;
        }
    }

    int readInternal(ByteBuffer buf) throws IOException {
        int n = OS.read0(this.fd, ((DirectBuffer)((Object)buf)).address() + (long)buf.position(), buf.remaining());
        if (n == -3 && this.isOpen()) {
            return 0;
        }
        int ret = IOStatus.normalize(n);
        if (ret > 0) {
            buf.position(buf.position() + ret);
        } else if (ret < 0) {
            this.open = false;
        }
        return ret;
    }
}

