/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.cleaner.CleanerServiceLocator;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;

public enum IOTools {


    public static boolean shallowDeleteDirWithFiles(@NotNull String directory) throws IORuntimeException {
        return IOTools.shallowDeleteDirWithFiles(new File(directory));
    }

    public static boolean shallowDeleteDirWithFiles(@NotNull File dir) throws IORuntimeException {
        return IOTools.deleteDirWithFiles(dir, 1);
    }

    public static boolean deleteDirWithFiles(@NotNull String dir, int maxDepth) throws IORuntimeException {
        return IOTools.deleteDirWithFiles(new File(dir), maxDepth);
    }

    public static boolean deleteDirWithFiles(@NotNull File dir, int maxDepth) throws IORuntimeException {
        File[] entries = dir.listFiles();
        if (entries == null) {
            return false;
        }
        Stream.of(entries).filter(File::isDirectory).forEach(f -> {
            if (maxDepth < 1) {
                throw new AssertionError((Object)("Contains directory " + f));
            }
            IOTools.deleteDirWithFiles(f, maxDepth - 1);
        });
        Stream.of(entries).forEach(f -> {
            try {
                Files.delete(f.toPath());
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e) {
                Jvm.debug().on(Closeable.class, "Failed to delete " + f, e);
            }
        });
        return dir.delete();
    }

    @Deprecated
    public static URL urlFor(String name) throws FileNotFoundException {
        return IOTools.urlFor(Thread.currentThread().getContextClassLoader(), name);
    }

    @NotNull
    public static URL urlFor(Class clazz, String name) throws FileNotFoundException {
        return IOTools.urlFor(clazz.getClassLoader(), name);
    }

    @NotNull
    public static URL urlFor(ClassLoader classLoader, String name) throws FileNotFoundException {
        URL url = classLoader.getResource(name);
        if (url == null && name.startsWith("/")) {
            url = classLoader.getResource(name.substring(1));
        }
        if (url == null) {
            url = classLoader.getResource(name + ".gz");
        }
        if (url == null) {
            throw new FileNotFoundException(name);
        }
        return url;
    }

    public static InputStream open(URL url) throws IOException {
        InputStream in = url.openStream();
        if (url.getFile().endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static byte[] readFile(@NotNull String name) throws IOException {
        URL url = IOTools.urlFor(name);
        InputStream is = IOTools.open(url);
        return IOTools.readAsBytes(is);
    }

    public static byte[] readFile(Class clazz, @NotNull String name) throws IOException {
        URL url = IOTools.urlFor(clazz, name);
        InputStream is = IOTools.open(url);
        return IOTools.readAsBytes(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAsBytes(InputStream is) throws IOException {
        try {
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream(Math.min(512, is.available()));
            byte[] bytes = new byte[1024];
            while ((len = is.read(bytes)) > 0) {
                out.write(bytes, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            Closeable.closeQuietly((Object)is);
        }
    }

    public static void writeFile(@NotNull String filename, @NotNull byte[] bytes) throws IOException {
        try (FileOutputStream out0 = new FileOutputStream(filename);){
            OutputStream out = out0;
            if (filename.endsWith(".gz")) {
                out = new GZIPOutputStream(out);
            }
            ((OutputStream)out).write(bytes);
            ((OutputStream)out).close();
        }
    }

    @NotNull
    public static String tempName(@NotNull String filename) {
        int ext = filename.lastIndexOf(46);
        if (ext > 0 && ext > filename.length() - 5) {
            return filename.substring(0, ext) + System.nanoTime() + filename.substring(ext);
        }
        return filename + System.nanoTime();
    }

    public static void clean(ByteBuffer bb) {
        CleanerServiceLocator.cleanerService().clean(bb);
    }

    public static void createDirectories(Path dir) throws IOException {
        block6: {
            if (dir == null || dir.getNameCount() == 0 || Files.isDirectory(dir, new LinkOption[0])) {
                return;
            }
            IOTools.createDirectories(dir.getParent());
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isSymbolicLink(dir)) {
                    throw new IOException("Symbolic link from " + dir + " to " + Files.readSymbolicLink(dir) + " is broken", e);
                }
                if (Files.isRegularFile(dir, new LinkOption[0])) {
                    throw new IOException("Cannot create a directory with the same name as a file " + dir, e);
                }
            }
            catch (AccessDeniedException e) {
                if (dir.toFile().canWrite()) break block6;
                throw new IOException("Cannot write to " + dir, e);
            }
        }
    }
}

