/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.EnumCache;

public class DynamicEnumClass<E extends Enum<E>>
extends EnumCache<E> {
    final Map<String, E> eMap = Collections.synchronizedMap(new LinkedHashMap());
    private final Field nameField;
    private final Field ordinalField;
    private final Function<String, E> create = this::create;

    DynamicEnumClass(Class<E> eClass) {
        super(eClass);
        for (Enum e : (Enum[])eClass.getEnumConstants()) {
            this.eMap.put(e.name(), e);
        }
        this.nameField = Jvm.getField(eClass, "name");
        this.ordinalField = Jvm.getField(eClass, "ordinal");
    }

    @Override
    public E valueOf(String name) {
        return (E)((Enum)this.eMap.computeIfAbsent(name, this.create));
    }

    private E create(String name) {
        try {
            Enum e = (Enum)OS.memory().allocateInstance(this.eClass);
            this.nameField.set(e, name);
            this.ordinalField.set(e, this.eMap.size());
            return (E)e;
        }
        catch (Exception e1) {
            throw new AssertionError((Object)e1);
        }
    }
}

