/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.CharSequenceInterner;
import net.openhft.chronicle.core.util.StringUtils;

public class StringInterner
implements CharSequenceInterner<String> {
    private final String[] interner;
    private final int mask;

    public StringInterner(int capacity) {
        int n = Maths.nextPower2(capacity, 128);
        this.interner = new String[n];
        this.mask = n - 1;
    }

    @Override
    public String intern(CharSequence cs) {
        String s2;
        long hash = 0L;
        for (int i = 0; i < cs.length(); ++i) {
            hash = 57L * hash + (long)cs.charAt(i);
        }
        int h = (int)Maths.hash(hash) & this.mask;
        String s = this.interner[h];
        if (StringUtils.isEqual(s, cs)) {
            return s;
        }
        this.interner[h] = s2 = cs.toString();
        return this.interner[h];
    }
}

