/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

public interface PersistenceMode {
    public static final PersistenceMode ASYNCHRONOUS = Modes.ASYNCHRONOUS;
    public static final PersistenceMode TO_DISK = Modes.TO_DISK;
    public static final PersistenceMode REMOTE_PUSHED = Modes.REMOTE_PUSHED;
    public static final PersistenceMode TO_DISK_REMOTE_PUSHED = Modes.TO_DISK_REMOTE_PUSHED;
    public static final PersistenceMode COMMIT_TWICE = Modes.COMMIT_TWICE;

    public boolean localCommit();

    public int minConfirms();

    public int minRemoteCommits();

    public static enum Modes implements PersistenceMode
    {
        ASYNCHRONOUS(false, 0, 0),
        TO_DISK(true, 1, 0),
        REMOTE_PUSHED(false, 2, 0),
        TO_DISK_REMOTE_PUSHED(true, 2, 1),
        COMMIT_TWICE(true, 2, 2);

        private final boolean localCommit;
        private final int minConfirms;
        private final int minRemoteCommits;

        private Modes(boolean localCommit, int minConfirms, int minRemoteCommits) {
            this.localCommit = localCommit;
            this.minConfirms = minConfirms;
            this.minRemoteCommits = minRemoteCommits;
        }

        @Override
        public boolean localCommit() {
            return this.localCommit;
        }

        @Override
        public int minConfirms() {
            return this.minConfirms;
        }

        @Override
        public int minRemoteCommits() {
            return this.minRemoteCommits;
        }
    }
}

