/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.List;

public interface ReferenceCounted
extends Closeable {
    public static void release(ReferenceCounted rc) {
        if (rc != null) {
            rc.release();
        }
    }

    public static void releaseAll(List<WeakReference<ReferenceCounted>> refCounts) {
        for (WeakReference<ReferenceCounted> refCountRef : refCounts) {
            ReferenceCounted refCounted;
            if (refCountRef == null || (refCounted = (ReferenceCounted)refCountRef.get()) == null) continue;
            refCounted.release();
        }
    }

    public void reserve() throws IllegalStateException;

    public void release() throws IllegalStateException;

    @Override
    default public void close() {
        this.release();
    }

    public long refCount();

    default public boolean tryReserve() {
        try {
            if (this.refCount() > 0L) {
                this.reserve();
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return false;
    }
}

