/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.Monitorable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public enum MappedUniqueTimeProvider implements TimeProvider,
ReferenceOwner
{
    INSTANCE;

    private static final int LAST_TIME = 128;
    private static final int NANOS_PER_MICRO = 1000;
    private final BytesStore<?, ?> bytesStore;
    private TimeProvider provider = SystemTimeProvider.INSTANCE;

    private MappedUniqueTimeProvider() {
        try {
            String user = Jvm.getProperty((String)"user.name", (String)"unknown");
            String timeStampDir = Jvm.getProperty((String)"timestamp.dir", (String)OS.TMP);
            File timeStampPath = new File(timeStampDir, ".time-stamp." + user + ".dat");
            MappedFile file = MappedFile.ofSingle(timeStampPath, PageUtil.getPageSize(timeStampPath.getAbsolutePath()), false);
            Bytes<?> bytes = file.acquireBytesForWrite(this, 0L);
            bytes.append8bit("&TSF\nTime stamp file used for sharing a unique id\n");
            this.bytesStore = bytes.bytesStore();
            Monitorable.unmonitor((Object)((Object)file));
            Monitorable.unmonitor(bytes);
        }
        catch (Exception ioe) {
            throw new IORuntimeException((Throwable)ioe);
        }
    }

    public MappedUniqueTimeProvider provider(TimeProvider provider) {
        this.provider = provider;
        return this;
    }

    public long currentTimeMillis() {
        return this.provider.currentTimeMillis();
    }

    public long currentTimeMicros() throws IllegalStateException {
        long timeus = this.provider.currentTimeMicros();
        long time0us;
        long time;
        long time0;
        while (!this.casLastTimeStored(time0, time = (time0us = (time0 = this.lastTimeStored()) / 1000L) >= timeus ? (time0us + 1L) * 1000L : timeus * 1000L)) {
            Jvm.nanoPause();
        }
        return time / 1000L;
    }

    public long currentTimeNanos() throws IllegalStateException {
        long time0;
        long timeNanos5;
        long time = this.provider.currentTimeNanos();
        long time5 = time >>> 5;
        if (time5 > (timeNanos5 = (time0 = this.lastTimeStored()) >>> 5) && this.casLastTimeStored(time0, time)) {
            return time;
        }
        long next;
        while (!this.casLastTimeStored(time0 = this.lastTimeStored(), next = time0 + 32L & 0xFFFFFFFFFFFFFFE0L)) {
            Jvm.nanoPause();
        }
        return next;
    }

    private long lastTimeStored() {
        return this.bytesStore.readVolatileLong(128L);
    }

    private boolean casLastTimeStored(long expected, long value) {
        return this.bytesStore.compareAndSwapLong(128L, expected, value);
    }
}

