/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.IOException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;

public final class Unmapper
implements Runnable {
    private final long size;
    private final int pageSize;
    private volatile long address;

    public Unmapper(long address, long size, int pageSize) throws IllegalStateException {
        assert (address != 0L);
        this.address = address;
        this.size = size;
        this.pageSize = pageSize;
    }

    @Override
    public void run() {
        if (this.address == 0L) {
            return;
        }
        try {
            OS.unmap((long)this.address, (long)this.size, (int)this.pageSize);
            this.address = 0L;
        }
        catch (IOException e) {
            Jvm.warn().on(OS.class, "Error on unmap and release", (Throwable)e);
        }
    }
}

