/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BinaryBytesMethodWriterInvocationHandler;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesPrepender;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HexDumpBytesDescription;
import net.openhft.chronicle.bytes.MethodEncoderLookup;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.io.ValidatableUtil;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public interface BytesOut<U>
extends StreamingDataOutput<Bytes<U>>,
ByteStringAppender<Bytes<U>>,
BytesPrepender<Bytes<U>>,
HexDumpBytesDescription<BytesOut<U>> {
    @NotNull
    default public <T> T bytesMethodWriter(@NotNull Class<T> tClass, Class<?> ... additional) throws IllegalArgumentException, ClosedIllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        Class[] interfaces = (Class[])ObjectUtils.addAll(tClass, (Object[])additional);
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), interfaces, (InvocationHandler)new BinaryBytesMethodWriterInvocationHandler(tClass, MethodEncoderLookup.BY_ANNOTATION, this));
    }

    public void writeMarshallableLength16(WriteBytesMarshallable var1) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, InvalidMarshallableException, ClosedIllegalStateException, ThreadingIllegalStateException;

    default public void writeObject(Class<?> componentType, Object obj) throws IllegalArgumentException, BufferOverflowException, ArithmeticException, ClosedIllegalStateException, BufferUnderflowException, InvalidMarshallableException, ThreadingIllegalStateException {
        if (!componentType.isInstance(obj)) {
            throw new IllegalArgumentException("Cannot serialize " + obj.getClass() + " as an " + componentType);
        }
        if (obj instanceof BytesMarshallable) {
            ValidatableUtil.validate((Object)obj);
            ((BytesMarshallable)obj).writeMarshallable(this);
            return;
        }
        if (obj instanceof Enum) {
            this.writeEnum((Enum)obj);
            return;
        }
        if (obj instanceof BytesStore) {
            BytesStore bs = (BytesStore)obj;
            this.writeStopBit(bs.readRemaining());
            this.write(bs);
            return;
        }
        switch (componentType.getName()) {
            case "java.lang.String": {
                this.writeUtf8((String)obj);
                return;
            }
            case "java.lang.Double": {
                this.writeDouble((Double)obj);
                return;
            }
            case "java.lang.Long": {
                this.writeLong((Long)obj);
                return;
            }
            case "java.lang.Integer": {
                this.writeInt((Integer)obj);
                return;
            }
        }
        throw new UnsupportedOperationException("Not supported " + componentType);
    }
}

