/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.render;

import net.openhft.chronicle.bytes.render.DecimalAppender;
import net.openhft.chronicle.bytes.render.Decimaliser;
import net.openhft.chronicle.bytes.render.SimpleDecimaliser;
import net.openhft.chronicle.bytes.render.UsesBigDecimal;

public class GeneralDecimaliser
implements Decimaliser {
    public static final Decimaliser GENERAL = new GeneralDecimaliser();

    @Override
    public boolean toDecimal(double value, DecimalAppender decimalAppender) {
        double absValue = Math.abs(value);
        if (value == 0.0 || 1.0E-29 <= absValue && absValue < 1.0E45) {
            return SimpleDecimaliser.SIMPLE.toDecimal(value, decimalAppender) || UsesBigDecimal.USES_BIG_DECIMAL.toDecimal(value, decimalAppender);
        }
        return false;
    }

    @Override
    public boolean toDecimal(float value, DecimalAppender decimalAppender) {
        float absValue = Math.abs(value);
        if (value == 0.0f || 1.0E-29f <= absValue) {
            return SimpleDecimaliser.SIMPLE.toDecimal(value, decimalAppender) || UsesBigDecimal.USES_BIG_DECIMAL.toDecimal(value, decimalAppender);
        }
        return false;
    }
}

