/*
 * Copyright (c) 2016-2022 chronicle.software
 *
 *     https://chronicle.software
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.openhft.chronicle.bytes;

import org.jetbrains.annotations.NotNull;

/**
 * Extension of the BytesRingBuffer interface that supports multiple readers.
 * Each reader in a MultiReaderBytesRingBuffer has a separate read position,
 * allowing independent progression through the buffer.
 */
public interface MultiReaderBytesRingBuffer extends BytesRingBuffer {

    /**
     * Creates a RingBufferReader with a default ID of 0.
     *
     * @return a new RingBufferReader
     */
    @NotNull
    default RingBufferReader createReader() {
        return createReader(0);
    }

    /**
     * Creates a RingBufferReader with a specified reader ID.
     * Each reader has a separate read position, which allows independent progression through the buffer.
     *
     * @param id the identifier for the new reader
     * @return a new RingBufferReader with the given ID
     */
    @NotNull
    RingBufferReader createReader(int id);
}
