/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.MethodEncoder;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.core.Jvm;

public enum MethodEncoderLookup implements Function<Method, MethodEncoder>
{
    BY_ANNOTATION;


    @Override
    public MethodEncoder apply(Method method) {
        MethodId methodId = (MethodId)Jvm.findAnnotation((AnnotatedElement)method, MethodId.class);
        if (methodId == null) {
            return null;
        }
        final long messageId = methodId.value();
        return new MethodEncoder(){

            @Override
            public long messageId() {
                return messageId;
            }

            @Override
            public void encode(Object[] objects, BytesOut<?> out) throws IllegalArgumentException, BufferUnderflowException, IllegalStateException, BufferOverflowException, ArithmeticException {
                for (Object object : objects) {
                    if (!(object instanceof BytesMarshallable)) {
                        throw new IllegalArgumentException("Object type " + object + " not supported");
                    }
                    ((BytesMarshallable)object).writeMarshallable(out);
                }
            }

            @Override
            public Object[] decode(Object[] lastObjects, BytesIn<?> in) throws BufferUnderflowException, IllegalStateException {
                for (Object lastObject : lastObjects) {
                    ((BytesMarshallable)lastObject).readMarshallable(in);
                }
                return lastObjects;
            }
        };
    }
}

